/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.leader;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.cloud.kubernetes.commons.leader.LeaderProperties;
import org.springframework.cloud.kubernetes.commons.leader.LeaderRecordWatcher;
import org.springframework.cloud.kubernetes.commons.leader.LeaderUtils;
import org.springframework.cloud.kubernetes.fabric8.leader.Fabric8LeadershipController;
import org.springframework.core.log.LogAccessor;

public class Fabric8LeaderRecordWatcher
implements LeaderRecordWatcher,
Watcher<ConfigMap> {
    private static final LogAccessor LOGGER = new LogAccessor(Fabric8LeaderRecordWatcher.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Fabric8LeadershipController fabric8LeadershipController;
    private final LeaderProperties leaderProperties;
    private final KubernetesClient kubernetesClient;
    private volatile Watch configMapWatch;

    public Fabric8LeaderRecordWatcher(LeaderProperties leaderProperties, Fabric8LeadershipController fabric8LeadershipController, KubernetesClient kubernetesClient) {
        this.fabric8LeadershipController = fabric8LeadershipController;
        this.leaderProperties = leaderProperties;
        this.kubernetesClient = kubernetesClient;
    }

    public void start() {
        if (this.configMapWatch == null) {
            LeaderUtils.guarded((ReentrantLock)this.lock, () -> {
                if (this.configMapWatch == null) {
                    LOGGER.debug(() -> "Starting leader record watcher");
                    this.configMapWatch = ((Resource)((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(this.leaderProperties.getNamespace(this.kubernetesClient.getNamespace()))).withName(this.leaderProperties.getConfigMapName())).watch((Watcher)this);
                }
            });
        }
    }

    public void stop() {
        if (this.configMapWatch != null) {
            LeaderUtils.guarded((ReentrantLock)this.lock, () -> {
                if (this.configMapWatch != null) {
                    LOGGER.debug(() -> "Stopping leader record watcher");
                    this.configMapWatch.close();
                    this.configMapWatch = null;
                }
            });
        }
    }

    public void eventReceived(Watcher.Action action, ConfigMap configMap) {
        LOGGER.debug(() -> action + " event received, triggering leadership update");
        if (!Watcher.Action.ERROR.equals((Object)action)) {
            this.fabric8LeadershipController.update();
        }
    }

    public void onClose(WatcherException cause) {
        if (cause != null) {
            LeaderUtils.guarded((ReentrantLock)this.lock, () -> {
                LOGGER.warn(() -> "Watcher stopped unexpectedly, will restart because of : " + cause);
                this.configMapWatch = null;
                this.start();
            });
        }
    }
}

