/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.fabric8.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListMultiDeletable;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryHealthIndicatorEnabled;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.fabric8.Fabric8AutoConfiguration;
import org.springframework.cloud.kubernetes.fabric8.discovery.ConditionalOnKubernetesDiscoveryEnabled;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesClientServicesFunction;
import org.springframework.cloud.kubernetes.fabric8.discovery.KubernetesDiscoveryClient;
import org.springframework.cloud.kubernetes.fabric8.discovery.ServicePortSecureResolver;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDiscoveryEnabled
@ConditionalOnKubernetesEnabled
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={Fabric8AutoConfiguration.class})
public class KubernetesDiscoveryClientAutoConfiguration {
    @Bean
    public KubernetesClientServicesFunction servicesFunction(KubernetesDiscoveryProperties properties) {
        if (properties.getServiceLabels().isEmpty()) {
            if (properties.isAllNamespaces()) {
                return client -> (FilterWatchListMultiDeletable)client.services().inAnyNamespace();
            }
            return KubernetesClient::services;
        }
        if (properties.isAllNamespaces()) {
            return client -> (FilterWatchListDeletable)((FilterWatchListMultiDeletable)client.services().inAnyNamespace()).withLabels(properties.getServiceLabels());
        }
        return client -> (FilterWatchListDeletable)client.services().withLabels(properties.getServiceLabels());
    }

    @Bean
    public KubernetesDiscoveryProperties getKubernetesDiscoveryProperties() {
        return new KubernetesDiscoveryProperties();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @ConditionalOnKubernetesDiscoveryEnabled
    public static class KubernetesDiscoveryClientConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public KubernetesDiscoveryClient kubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties, KubernetesClientServicesFunction kubernetesClientServicesFunction) {
            return new KubernetesDiscoveryClient(client, properties, kubernetesClientServicesFunction, new ServicePortSecureResolver(properties));
        }
    }

    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnDiscoveryEnabled
    @ConditionalOnDiscoveryHealthIndicatorEnabled
    @Configuration
    public static class KubernetesDiscoveryClientHealthIndicatorConfiguration {
        @Bean
        public KubernetesDiscoveryClientHealthIndicatorInitializer indicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils podUtils) {
            return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
        }
    }
}

