/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.kubernetes.config.AbstractConfigProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.kubernetes.secrets")
public class SecretsConfigProperties
extends AbstractConfigProperties {
    private static final String TARGET = "Secret";
    private boolean enableApi = false;
    private Map<String, String> labels = new HashMap<String, String>();
    private List<String> paths = new LinkedList<String>();
    private List<Source> sources = new LinkedList<Source>();

    public boolean isEnableApi() {
        return this.enableApi;
    }

    public void setEnableApi(boolean enableApi) {
        this.enableApi = enableApi;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    @Override
    public String getConfigurationTarget() {
        return TARGET;
    }

    public List<NormalizedSource> determineSources() {
        if (this.sources.isEmpty()) {
            return new ArrayList<NormalizedSource>(){
                {
                    this.add(new NormalizedSource(SecretsConfigProperties.this.name, SecretsConfigProperties.this.namespace, SecretsConfigProperties.this.labels));
                }
            };
        }
        return this.sources.stream().map(s -> s.normalize(this.name, this.namespace, this.labels)).collect(Collectors.toList());
    }

    static class NormalizedSource {
        private final String name;
        private final String namespace;
        private Map<String, String> labels = new HashMap<String, String>();

        NormalizedSource(String name, String namespace, Map<String, String> labels) {
            this.name = name;
            this.namespace = namespace;
            this.labels = labels;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }
    }

    public static class Source {
        private String name;
        private String namespace;
        private Map<String, String> labels = new HashMap<String, String>();

        public Source() {
        }

        public Source(String name, String namespace, Map<String, String> labels) {
            this.name = name;
            this.namespace = namespace;
            this.labels = labels;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public void setLabels(Map<String, String> labels) {
            this.labels = labels;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }

        public boolean isEmpty() {
            return StringUtils.isEmpty((Object)this.name) && StringUtils.isEmpty((Object)this.namespace);
        }

        public NormalizedSource normalize(String defaultName, String defaultNamespace, Map<String, String> defaultLabels) {
            String normalizedName = StringUtils.isEmpty((Object)this.name) ? defaultName : this.name;
            String normalizedNamespace = StringUtils.isEmpty((Object)this.namespace) ? defaultNamespace : this.namespace;
            Map<String, String> normalizedLabels = this.labels.isEmpty() ? defaultLabels : this.labels;
            return new NormalizedSource(normalizedName, normalizedNamespace, normalizedLabels);
        }
    }
}

