/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public final class PropertySourceUtils {
    static final Function<String, Properties> KEY_VALUE_TO_PROPERTIES = s -> {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(s.getBytes()));
            return properties;
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
    };
    static final Function<Properties, Map<String, Object>> PROPERTIES_TO_MAP = p -> p.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue, PropertySourceUtils.throwingMerger(), LinkedHashMap::new));

    private PropertySourceUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static Function<String, Properties> yamlParserGenerator(Environment environment) {
        return s -> {
            YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
            yamlFactory.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{properties -> {
                String profiles = properties.getProperty("spring.profiles");
                if (environment != null && StringUtils.hasText((String)profiles)) {
                    return environment.acceptsProfiles(Profiles.of((String[])new String[]{profiles})) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
                }
                return YamlProcessor.MatchStatus.ABSTAIN;
            }});
            yamlFactory.setResources(new Resource[]{new ByteArrayResource(s.getBytes())});
            return yamlFactory.getObject();
        };
    }

    static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

