/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.loadbalancer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesServiceInstance;
import org.springframework.util.StringUtils;

public interface KubernetesServiceInstanceMapper<T> {
    public KubernetesServiceInstance map(T var1);

    public static String createHost(String serviceName, String namespace, String clusterDomain) {
        return String.format("%s.%s.svc.%s", serviceName, StringUtils.hasText((String)namespace) ? namespace : "default", clusterDomain);
    }

    public static boolean isSecure(Map<String, String> labels, Map<String, String> annotations, String servicePortName, Integer servicePort) {
        String securedAnnotationValue;
        String securedLabelValue;
        if (labels != null && (securedLabelValue = labels.getOrDefault("secured", "false")).equals("true")) {
            return true;
        }
        if (annotations != null && (securedAnnotationValue = annotations.getOrDefault("secured", "false")).equals("true")) {
            return true;
        }
        return servicePortName != null && servicePortName.endsWith("https") || servicePort.toString().endsWith("443");
    }

    public static Map<String, String> getMapWithPrefixedKeys(Map<String, String> map, String prefix) {
        if (map == null) {
            return new HashMap<String, String>();
        }
        if (!StringUtils.hasText((String)prefix)) {
            return map;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        map.forEach((k, v) -> result.put(prefix + k, (String)v));
        return result;
    }
}

