/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.kubernetes.reload")
public class ConfigReloadProperties {
    private boolean enabled = false;
    private boolean monitoringConfigMaps = true;
    private boolean monitoringSecrets = false;
    private ReloadStrategy strategy = ReloadStrategy.REFRESH;
    private ReloadDetectionMode mode = ReloadDetectionMode.EVENT;
    private Duration period = Duration.ofMillis(15000L);
    private Duration maxWaitForRestart = Duration.ofSeconds(2L);

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isMonitoringConfigMaps() {
        return this.monitoringConfigMaps;
    }

    public void setMonitoringConfigMaps(boolean monitoringConfigMaps) {
        this.monitoringConfigMaps = monitoringConfigMaps;
    }

    public boolean isMonitoringSecrets() {
        return this.monitoringSecrets;
    }

    public void setMonitoringSecrets(boolean monitoringSecrets) {
        this.monitoringSecrets = monitoringSecrets;
    }

    public ReloadStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ReloadStrategy strategy) {
        this.strategy = strategy;
    }

    public ReloadDetectionMode getMode() {
        return this.mode;
    }

    public void setMode(ReloadDetectionMode mode) {
        this.mode = mode;
    }

    public Duration getPeriod() {
        return this.period;
    }

    public void setPeriod(Duration period) {
        this.period = period;
    }

    public Duration getMaxWaitForRestart() {
        return this.maxWaitForRestart;
    }

    public void setMaxWaitForRestart(Duration maxWaitForRestart) {
        this.maxWaitForRestart = maxWaitForRestart;
    }

    public static enum ReloadDetectionMode {
        POLLING,
        EVENT;

    }

    public static enum ReloadStrategy {
        REFRESH,
        RESTART_CONTEXT,
        SHUTDOWN;

    }
}

