/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public final class PropertySourceUtils {
    public static final Function<String, Properties> KEY_VALUE_TO_PROPERTIES = s -> {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(s.getBytes()));
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };
    public static final Function<Properties, Map<String, Object>> PROPERTIES_TO_MAP = p -> p.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue));

    private PropertySourceUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static Function<String, Properties> yamlParserGenerator(Environment environment) {
        return s -> {
            YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
            yamlFactory.setDocumentMatchers(new YamlProcessor.DocumentMatcher[]{properties -> {
                if (environment != null) {
                    String profiles = null;
                    String activeOnProfile = properties.getProperty("spring.config.activate.on-profile");
                    String springProfiles = properties.getProperty("spring.profiles");
                    if (activeOnProfile != null) {
                        profiles = activeOnProfile;
                    } else if (springProfiles != null) {
                        profiles = springProfiles;
                    }
                    if (StringUtils.hasText((String)profiles)) {
                        return environment.acceptsProfiles(Profiles.of((String[])new String[]{profiles})) ? YamlProcessor.MatchStatus.FOUND : YamlProcessor.MatchStatus.NOT_FOUND;
                    }
                }
                return YamlProcessor.MatchStatus.ABSTAIN;
            }});
            yamlFactory.setResources(new Resource[]{new ByteArrayResource(s.getBytes())});
            return yamlFactory.getObject();
        };
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (left, right) -> {
            throw new IllegalStateException("Duplicate key " + left);
        };
    }
}

