/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.common.lang.Nullable;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.observation.DefaultGatewayObservationConvention;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayContext;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayDocumentedObservation;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayObservationConvention;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.util.context.ContextView;

public class ObservedRequestHttpHeadersFilter
implements HttpHeadersFilter {
    private static final Log log = LogFactory.getLog(ObservedRequestHttpHeadersFilter.class);
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final GatewayObservationConvention customGatewayObservationConvention;

    public ObservedRequestHttpHeadersFilter(ObservationRegistry observationRegistry) {
        this(observationRegistry, null);
    }

    public ObservedRequestHttpHeadersFilter(ObservationRegistry observationRegistry, @Nullable GatewayObservationConvention customGatewayObservationConvention) {
        this.observationRegistry = observationRegistry;
        this.customGatewayObservationConvention = customGatewayObservationConvention;
    }

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        HttpHeaders newHeaders = new HttpHeaders();
        newHeaders.putAll((Map)input);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will instrument the HTTP request headers " + newHeaders));
        }
        Observation parentObservation = this.getParentObservation(exchange);
        GatewayContext gatewayContext = new GatewayContext(newHeaders, exchange.getRequest(), exchange);
        Observation childObservation = GatewayDocumentedObservation.GATEWAY_HTTP_CLIENT_OBSERVATION.observation(this.customGatewayObservationConvention, DefaultGatewayObservationConvention.INSTANCE, () -> gatewayContext, this.observationRegistry);
        if (parentObservation != null) {
            childObservation.parentObservation(parentObservation);
        }
        childObservation.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Client observation  " + childObservation + " created for the request. New headers are " + newHeaders));
        }
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_OBSERVATION_ATTR, childObservation);
        return newHeaders;
    }

    private Observation getParentObservation(ServerWebExchange exchange) {
        ContextView contextView = (ContextView)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_REACTOR_CONTEXT_ATTR);
        if (contextView == null) {
            return null;
        }
        return (Observation)contextView.getOrDefault((Object)"micrometer.observation", null);
    }

    @Override
    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.REQUEST);
    }
}

