/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="spring.cloud.gateway.filter.local-response-cache")
public class LocalResponseCacheProperties {
    static final String PREFIX = "spring.cloud.gateway.filter.local-response-cache";
    private static final Log LOGGER = LogFactory.getLog(LocalResponseCacheProperties.class);
    private static final Duration DEFAULT_CACHE_TTL_SECONDS = Duration.ofMinutes(5L);
    private DataSize size;
    private Duration timeToLive;

    public DataSize getSize() {
        return this.size;
    }

    public void setSize(DataSize size) {
        this.size = size;
    }

    public Duration getTimeToLive() {
        if (this.timeToLive == null) {
            LOGGER.debug((Object)String.format("No TTL configuration found. Default TTL will be applied for cache entries: %s seconds", DEFAULT_CACHE_TTL_SECONDS));
            return DEFAULT_CACHE_TTL_SECONDS;
        }
        return this.timeToLive;
    }

    public void setTimeToLive(Duration timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String toString() {
        return "LocalResponseCacheProperties{timeToLive=" + this.getTimeToLive() + "', size='" + this.getSize() + "}";
    }
}

