/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class TokenRelayGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    private final ObjectProvider<ReactiveOAuth2AuthorizedClientManager> clientManagerProvider;

    public TokenRelayGatewayFilterFactory(ObjectProvider<ReactiveOAuth2AuthorizedClientManager> clientManagerProvider) {
        super(Object.class);
        this.clientManagerProvider = clientManagerProvider;
    }

    public GatewayFilter apply() {
        return this.apply((Object)null);
    }

    @Override
    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> exchange.getPrincipal().filter(principal -> principal instanceof OAuth2AuthenticationToken).cast(OAuth2AuthenticationToken.class).flatMap(authentication -> this.authorizedClient(exchange, (OAuth2AuthenticationToken)authentication)).map(OAuth2AuthorizedClient::getAccessToken).map(token -> this.withBearerAuth(exchange, (OAuth2AccessToken)token)).defaultIfEmpty((Object)exchange).flatMap(chain::filter);
    }

    private Mono<OAuth2AuthorizedClient> authorizedClient(ServerWebExchange exchange, OAuth2AuthenticationToken oauth2Authentication) {
        String clientRegistrationId = oauth2Authentication.getAuthorizedClientRegistrationId();
        OAuth2AuthorizeRequest request = OAuth2AuthorizeRequest.withClientRegistrationId((String)clientRegistrationId).principal((Authentication)oauth2Authentication).build();
        ReactiveOAuth2AuthorizedClientManager clientManager = (ReactiveOAuth2AuthorizedClientManager)this.clientManagerProvider.getIfAvailable();
        if (clientManager == null) {
            return Mono.error((Throwable)new IllegalStateException("No ReactiveOAuth2AuthorizedClientManager bean was found. Did you include the org.springframework.boot:spring-boot-starter-oauth2-client dependency?"));
        }
        return clientManager.authorize(request);
    }

    private ServerWebExchange withBearerAuth(ServerWebExchange exchange, OAuth2AccessToken accessToken) {
        return exchange.mutate().request(r -> r.headers(headers -> headers.setBearerAuth(accessToken.getTokenValue()))).build();
    }
}

