/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class WebsocketRoutingFilter
implements GlobalFilter,
Ordered {
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final Log log = LogFactory.getLog(WebsocketRoutingFilter.class);
    private final WebSocketClient webSocketClient;
    private final WebSocketService webSocketService;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider;
    private volatile List<HttpHeadersFilter> headersFilters;

    public WebsocketRoutingFilter(WebSocketClient webSocketClient, WebSocketService webSocketService, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider) {
        this.webSocketClient = webSocketClient;
        this.webSocketService = webSocketService;
        this.headersFiltersProvider = headersFiltersProvider;
    }

    static String convertHttpToWs(String scheme) {
        return "http".equals(scheme = scheme.toLowerCase()) ? "ws" : ("https".equals(scheme) ? "wss" : scheme);
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        WebsocketRoutingFilter.changeSchemeIfIsWebSocketUpgrade(exchange);
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange) || !"ws".equals(scheme) && !"wss".equals(scheme)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange);
        HttpHeaders headers = exchange.getRequest().getHeaders();
        HttpHeaders filtered = HttpHeadersFilter.filterRequest(this.getHeadersFilters(), exchange);
        List<String> protocols = this.getProtocols(headers);
        return this.webSocketService.handleRequest(exchange, (WebSocketHandler)new ProxyWebSocketHandler(requestUrl, this.webSocketClient, filtered, protocols));
    }

    List<String> getProtocols(HttpHeaders headers) {
        ArrayList<String> protocols = headers.get((Object)SEC_WEBSOCKET_PROTOCOL);
        if (protocols != null) {
            ArrayList<String> updatedProtocols = new ArrayList<String>();
            for (int i = 0; i < protocols.size(); ++i) {
                String protocol = (String)protocols.get(i);
                updatedProtocols.addAll(Arrays.asList(StringUtils.tokenizeToStringArray((String)protocol, (String)",")));
            }
            protocols = updatedProtocols;
        }
        return protocols;
    }

    List<HttpHeadersFilter> getHeadersFilters() {
        if (this.headersFilters == null) {
            this.headersFilters = (List)this.headersFiltersProvider.getIfAvailable(ArrayList::new);
            this.headersFilters.add((headers, exchange) -> {
                HttpHeaders filtered = new HttpHeaders();
                filtered.addAll((MultiValueMap)headers);
                filtered.remove((Object)"Host");
                boolean preserveHost = (Boolean)exchange.getAttributeOrDefault(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, (Object)false);
                if (preserveHost) {
                    String host = exchange.getRequest().getHeaders().getFirst("Host");
                    filtered.add("Host", host);
                }
                return filtered;
            });
            this.headersFilters.add((headers, exchange) -> {
                HttpHeaders filtered = new HttpHeaders();
                for (Map.Entry entry : headers.entrySet()) {
                    if (((String)entry.getKey()).toLowerCase().startsWith("sec-websocket")) continue;
                    filtered.addAll((String)entry.getKey(), (List)entry.getValue());
                }
                return filtered;
            });
        }
        return this.headersFilters;
    }

    static void changeSchemeIfIsWebSocketUpgrade(ServerWebExchange exchange) {
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme().toLowerCase();
        String upgrade = exchange.getRequest().getHeaders().getUpgrade();
        if ("WebSocket".equalsIgnoreCase(upgrade) && ("http".equals(scheme) || "https".equals(scheme))) {
            String wsScheme = WebsocketRoutingFilter.convertHttpToWs(scheme);
            boolean encoded = ServerWebExchangeUtils.containsEncodedParts(requestUrl);
            URI wsRequestUrl = UriComponentsBuilder.fromUri((URI)requestUrl).scheme(wsScheme).build(encoded).toUri();
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, wsRequestUrl);
            if (log.isTraceEnabled()) {
                log.trace((Object)("changeSchemeTo:[" + wsRequestUrl + "]"));
            }
        }
    }

    private static class ProxyWebSocketHandler
    implements WebSocketHandler {
        private final WebSocketClient client;
        private final URI url;
        private final HttpHeaders headers;
        private final List<String> subProtocols;

        ProxyWebSocketHandler(URI url, WebSocketClient client, HttpHeaders headers, List<String> protocols) {
            this.client = client;
            this.url = url;
            this.headers = headers;
            this.subProtocols = protocols != null ? protocols : Collections.emptyList();
        }

        public List<String> getSubProtocols() {
            return this.subProtocols;
        }

        public Mono<Void> handle(final WebSocketSession session) {
            return this.client.execute(this.url, this.headers, new WebSocketHandler(){

                public Mono<Void> handle(WebSocketSession proxySession) {
                    Mono serverClose = proxySession.closeStatus().filter(__ -> session.isOpen()).flatMap(arg_0 -> ((WebSocketSession)session).close(arg_0));
                    Mono proxyClose = session.closeStatus().filter(__ -> proxySession.isOpen()).flatMap(arg_0 -> ((WebSocketSession)proxySession).close(arg_0));
                    Mono proxySessionSend = proxySession.send((Publisher)session.receive().doOnNext(WebSocketMessage::retain).doOnNext(webSocketMessage -> {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("proxySession(send from client): " + proxySession.getId() + ", corresponding session:" + session.getId() + ", packet: " + webSocketMessage.getPayloadAsText()));
                        }
                    }));
                    Mono serverSessionSend = session.send((Publisher)proxySession.receive().doOnNext(WebSocketMessage::retain).doOnNext(webSocketMessage -> {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("session(send from backend): " + session.getId() + ", corresponding proxySession:" + proxySession.getId() + " packet: " + webSocketMessage.getPayloadAsText()));
                        }
                    }));
                    Mono.when((Publisher[])new Publisher[]{serverClose, proxyClose}).subscribe();
                    return Mono.zip((Mono)proxySessionSend, (Mono)serverSessionSend).then();
                }

                public List<String> getSubProtocols() {
                    return subProtocols;
                }
            });
        }
    }
}

