/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;
import org.springframework.cloud.gateway.config.AbstractSslConfigurer;
import org.springframework.cloud.gateway.config.HttpClientProperties;

public class GrpcSslConfigurer
extends AbstractSslConfigurer<NettyChannelBuilder, ManagedChannel> {
    public GrpcSslConfigurer(HttpClientProperties.Ssl sslProperties) {
        super(sslProperties);
    }

    @Override
    public ManagedChannel configureSsl(NettyChannelBuilder NettyChannelBuilder2) throws SSLException {
        return NettyChannelBuilder2.useTransportSecurity().sslContext(this.getSslContext()).build();
    }

    private SslContext getSslContext() throws SSLException {
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
        HttpClientProperties.Ssl ssl = this.getSslProperties();
        boolean useInsecureTrustManager = ssl.isUseInsecureTrustManager();
        if (useInsecureTrustManager) {
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE.getTrustManagers()[0]);
        }
        if (!useInsecureTrustManager && ssl.getTrustedX509Certificates().size() > 0) {
            sslContextBuilder.trustManager(this.getTrustedX509CertificatesForTrustManager());
        }
        return sslContextBuilder.keyManager(this.getKeyManagerFactory()).build();
    }
}

