/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.ipresolver;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.support.ipresolver.RemoteAddressResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class XForwardedRemoteAddressResolver
implements RemoteAddressResolver {
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final Logger log = LoggerFactory.getLogger(XForwardedRemoteAddressResolver.class);
    private final RemoteAddressResolver defaultRemoteIpResolver = new RemoteAddressResolver(){};
    private final int maxTrustedIndex;

    private XForwardedRemoteAddressResolver(int maxTrustedIndex) {
        this.maxTrustedIndex = maxTrustedIndex;
    }

    public static XForwardedRemoteAddressResolver trustAll() {
        return new XForwardedRemoteAddressResolver(Integer.MAX_VALUE);
    }

    public static XForwardedRemoteAddressResolver maxTrustedIndex(int maxTrustedIndex) {
        Assert.isTrue((maxTrustedIndex > 0 ? 1 : 0) != 0, (String)"An index greater than 0 is required");
        return new XForwardedRemoteAddressResolver(maxTrustedIndex);
    }

    @Override
    public InetSocketAddress resolve(ServerWebExchange exchange) {
        List<String> xForwardedValues = this.extractXForwardedValues(exchange);
        Collections.reverse(xForwardedValues);
        if (!xForwardedValues.isEmpty()) {
            int index = Math.min(xForwardedValues.size(), this.maxTrustedIndex) - 1;
            return new InetSocketAddress(xForwardedValues.get(index), 0);
        }
        return this.defaultRemoteIpResolver.resolve(exchange);
    }

    private List<String> extractXForwardedValues(ServerWebExchange exchange) {
        List xForwardedValues = exchange.getRequest().getHeaders().get((Object)X_FORWARDED_FOR);
        if (xForwardedValues == null || xForwardedValues.isEmpty()) {
            return Collections.emptyList();
        }
        if (xForwardedValues.size() > 1) {
            log.warn("Multiple X-Forwarded-For headers found, discarding all");
            return Collections.emptyList();
        }
        List<String> values = Arrays.asList(((String)xForwardedValues.get(0)).split(", "));
        if (values.size() == 1 && !StringUtils.hasText((String)values.get(0))) {
            return Collections.emptyList();
        }
        return values;
    }
}

