/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class GRPCRequestHeadersFilter
implements HttpHeadersFilter,
Ordered {
    @Override
    public HttpHeaders filter(HttpHeaders headers, ServerWebExchange exchange) {
        HttpHeaders updated = new HttpHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            updated.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        if (this.isGRPC(headers.getFirst("Content-Type"))) {
            updated.add("te", "trailers");
        }
        return updated;
    }

    private boolean isGRPC(String contentTypeValue) {
        return StringUtils.startsWithIgnoreCase((String)contentTypeValue, (String)"application/grpc");
    }

    @Override
    public boolean supports(HttpHeadersFilter.Type type) {
        return HttpHeadersFilter.Type.REQUEST.equals((Object)type);
    }

    public int getOrder() {
        return 0;
    }
}

