/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.common;

import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class MvcUtils {
    private static final Log log = LogFactory.getLog(MvcUtils.class);
    public static final String CACHED_REQUEST_BODY_ATTR = MvcUtils.qualify("cachedRequestBody");
    public static final String CLIENT_RESPONSE_INPUT_STREAM_ATTR = MvcUtils.qualify("cachedClientResponseBody");
    public static final String CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR = MvcUtils.qualify("circuitBreakerExecutionException");
    public static final String GATEWAY_ATTRIBUTES_ATTR = MvcUtils.qualify("gatewayAttributes");
    public static final String GATEWAY_ORIGINAL_REQUEST_URL_ATTR = MvcUtils.qualify("gatewayOriginalRequestUrl");
    public static final String GATEWAY_REQUEST_URL_ATTR = MvcUtils.qualify("gatewayRequestUrl");
    public static final String GATEWAY_ROUTE_ID_ATTR = MvcUtils.qualify("gatewayRouteId");
    public static final String PRESERVE_HOST_HEADER_ATTRIBUTE = MvcUtils.qualify("preserveHostHeader");
    public static final String WEIGHT_ATTR = MvcUtils.qualify("routeWeight");

    private MvcUtils() {
    }

    private static String qualify(String attr) {
        return "GatewayServerMvc." + attr;
    }

    public static <T> Optional<T> cacheAndReadBody(ServerRequest request, Class<T> toClass) {
        ByteArrayInputStream rawBody = MvcUtils.cacheBody(request);
        return MvcUtils.readBody(request, rawBody, toClass);
    }

    public static ByteArrayInputStream cacheBody(ServerRequest request) {
        try {
            byte[] bytes = StreamUtils.copyToByteArray((InputStream)request.servletRequest().getInputStream());
            ByteArrayInputStream body = new ByteArrayInputStream(bytes);
            MvcUtils.putAttribute(request, CACHED_REQUEST_BODY_ATTR, body);
            return body;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static ByteArrayInputStream getOrCacheBody(ServerRequest request) {
        ByteArrayInputStream body = (ByteArrayInputStream)MvcUtils.getAttribute(request, CACHED_REQUEST_BODY_ATTR);
        if (body != null) {
            return body;
        }
        return MvcUtils.cacheBody(request);
    }

    public static String expand(ServerRequest request, String template) {
        Assert.notNull((Object)request, (String)"request may not be null");
        Assert.notNull((Object)template, (String)"template may not be null");
        if (template.indexOf(123) == -1) {
            return template;
        }
        Map<String, Object> variables = MvcUtils.getUriTemplateVariables(request);
        try {
            return UriComponentsBuilder.fromPath((String)template).build().expand(variables).getPath();
        }
        catch (IllegalArgumentException e) {
            log.trace((Object)LogMessage.format((String)"unable to find substitution for %s", (Object)template), (Throwable)e);
            return template;
        }
    }

    public static List<String> expandMultiple(ServerRequest request, Collection<String> templates) {
        return templates.stream().map(value -> MvcUtils.expand(request, value)).toList();
    }

    public static String[] expandMultiple(ServerRequest request, String ... templates) {
        List<String> expanded = Arrays.stream(templates).map(value -> MvcUtils.expand(request, value)).toList();
        return expanded.toArray(new String[0]);
    }

    public static ApplicationContext getApplicationContext(ServerRequest request) {
        WebApplicationContext webApplicationContext = RequestContextUtils.findWebApplicationContext((HttpServletRequest)request.servletRequest());
        if (webApplicationContext == null) {
            throw new IllegalStateException("No Application Context in request attributes");
        }
        return webApplicationContext;
    }

    public static <T> T getAttribute(ServerRequest request, String key) {
        if (request.attributes().containsKey(key)) {
            return (T)request.attributes().get(key);
        }
        return (T)MvcUtils.getGatewayAttributes(request).get(key);
    }

    public static Map<String, Object> getGatewayAttributes(ServerRequest request) {
        Map attributes = (Map)request.attributes().computeIfAbsent(GATEWAY_ATTRIBUTES_ATTR, s -> new HashMap());
        return attributes;
    }

    public static Map<String, Object> getUriTemplateVariables(ServerRequest request) {
        Map reqUriTemplateVars = (Map)request.attributes().get(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        Map gatewayUriTemplateVars = (Map)MvcUtils.getGatewayAttributes(request).get(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        Map<String, Object> merged = MvcUtils.mergeMaps(reqUriTemplateVars, gatewayUriTemplateVars);
        return merged;
    }

    public static void putAttribute(ServerRequest request, String key, Object value) {
        request.attributes().put(key, value);
        MvcUtils.getGatewayAttributes(request).put(key, value);
    }

    public static void putUriTemplateVariables(ServerRequest request, Map<String, String> uriVariables) {
        Map pathVariables = request.pathVariables();
        Map<String, String> merged = MvcUtils.mergeMaps(pathVariables, uriVariables);
        MvcUtils.putAttribute(request, RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, merged);
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> left, Map<K, V> right) {
        if (CollectionUtils.isEmpty(left)) {
            if (CollectionUtils.isEmpty(right)) {
                return Collections.emptyMap();
            }
            return right;
        }
        if (CollectionUtils.isEmpty(right)) {
            return left;
        }
        LinkedHashMap result = CollectionUtils.newLinkedHashMap((int)(left.size() + right.size()));
        result.putAll(left);
        result.putAll(right);
        return result;
    }

    public static <T> Optional<T> readBody(ServerRequest request, ByteArrayInputStream body, Class<T> toClass) {
        try {
            ByteArrayInputMessage inputMessage = new ByteArrayInputMessage(request, body);
            List httpMessageConverters = request.messageConverters();
            for (HttpMessageConverter messageConverter : httpMessageConverters) {
                if (!messageConverter.canRead(toClass, (MediaType)request.headers().contentType().orElse(null))) continue;
                Object convertedValue = messageConverter.read(toClass, (HttpInputMessage)inputMessage);
                return Optional.of(convertedValue);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return Optional.empty();
    }

    public static void setRouteId(ServerRequest request, String routeId) {
        request.attributes().put(GATEWAY_ROUTE_ID_ATTR, routeId);
        request.servletRequest().setAttribute(GATEWAY_ROUTE_ID_ATTR, (Object)routeId);
    }

    public static void setRequestUrl(ServerRequest request, URI url) {
        request.attributes().put(GATEWAY_REQUEST_URL_ATTR, url);
        request.servletRequest().setAttribute(GATEWAY_REQUEST_URL_ATTR, (Object)url);
    }

    public static void addOriginalRequestUrl(ServerRequest request, URI url) {
        LinkedHashSet urls = (LinkedHashSet)request.attributes().computeIfAbsent(GATEWAY_ORIGINAL_REQUEST_URL_ATTR, s -> new LinkedHashSet());
        urls.add(url);
    }

    private record ByteArrayInputMessage(ServerRequest request, ByteArrayInputStream body) implements HttpInputMessage
    {
        public InputStream getBody() {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.request.headers().asHttpHeaders();
        }
    }
}

