/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.XForwardedRequestHeadersFilterProperties;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.ServerRequest;

@ConfigurationProperties(value="spring.cloud.gateway.x-forwarded")
public class XForwardedRequestHeadersFilter
implements HttpHeadersFilter.RequestHttpHeadersFilter,
Ordered {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    public static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    public static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    public static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    public static final String X_FORWARDED_PREFIX_HEADER = "X-Forwarded-Prefix";
    private int order = 0;
    private boolean enabled = true;
    private boolean forEnabled = true;
    private boolean hostEnabled = true;
    private boolean portEnabled = true;
    private boolean protoEnabled = true;
    private boolean prefixEnabled = true;
    private boolean forAppend = true;
    private boolean hostAppend = true;
    private boolean portAppend = true;
    private boolean protoAppend = true;
    private boolean prefixAppend = true;

    @Deprecated
    public XForwardedRequestHeadersFilter() {
        this(new XForwardedRequestHeadersFilterProperties());
    }

    public XForwardedRequestHeadersFilter(XForwardedRequestHeadersFilterProperties props) {
        PropertyMapper map = PropertyMapper.get();
        map.from(props::getOrder).to(o -> {
            this.order = o;
        });
        map.from(props::isEnabled).to(b -> {
            this.enabled = b;
        });
        map.from(props::isForEnabled).to(b -> {
            this.forEnabled = b;
        });
        map.from(props::isHostEnabled).to(b -> {
            this.hostEnabled = b;
        });
        map.from(props::isPortEnabled).to(b -> {
            this.portEnabled = b;
        });
        map.from(props::isProtoEnabled).to(b -> {
            this.protoEnabled = b;
        });
        map.from(props::isPrefixEnabled).to(b -> {
            this.prefixEnabled = b;
        });
        map.from(props::isForAppend).to(b -> {
            this.forAppend = b;
        });
        map.from(props::isHostAppend).to(b -> {
            this.hostAppend = b;
        });
        map.from(props::isPortAppend).to(b -> {
            this.portAppend = b;
        });
        map.from(props::isProtoAppend).to(b -> {
            this.protoAppend = b;
        });
        map.from(props::isPrefixAppend).to(b -> {
            this.prefixAppend = b;
        });
    }

    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.order")
    public int getOrder() {
        return this.order;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setOrder(int order) {
        this.order = order;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.for-enabled")
    public boolean isForEnabled() {
        return this.forEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setForEnabled(boolean forEnabled) {
        this.forEnabled = forEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.host-enabled")
    public boolean isHostEnabled() {
        return this.hostEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setHostEnabled(boolean hostEnabled) {
        this.hostEnabled = hostEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.port-enabled")
    public boolean isPortEnabled() {
        return this.portEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setPortEnabled(boolean portEnabled) {
        this.portEnabled = portEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.proto-enabled")
    public boolean isProtoEnabled() {
        return this.protoEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setProtoEnabled(boolean protoEnabled) {
        this.protoEnabled = protoEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.prefix-enabled")
    public boolean isPrefixEnabled() {
        return this.prefixEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setPrefixEnabled(boolean prefixEnabled) {
        this.prefixEnabled = prefixEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.for-append")
    public boolean isForAppend() {
        return this.forAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setForAppend(boolean forAppend) {
        this.forAppend = forAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.host-append")
    public boolean isHostAppend() {
        return this.hostAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setHostAppend(boolean hostAppend) {
        this.hostAppend = hostAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.port-append")
    public boolean isPortAppend() {
        return this.portAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setPortAppend(boolean portAppend) {
        this.portAppend = portAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.proto-append")
    public boolean isProtoAppend() {
        return this.protoAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setProtoAppend(boolean protoAppend) {
        this.protoAppend = protoAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.prefix-append")
    public boolean isPrefixAppend() {
        return this.prefixAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setPrefixAppend(boolean prefixAppend) {
        this.prefixAppend = prefixAppend;
    }

    @Override
    public HttpHeaders apply(HttpHeaders input, ServerRequest request) {
        HttpHeaders original = input;
        HttpHeaders updated = new HttpHeaders();
        for (Map.Entry entry : original.headerSet()) {
            updated.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        InetSocketAddress remoteAddress = request.remoteAddress().orElse(null);
        if (this.isForEnabled() && remoteAddress != null && remoteAddress.getAddress() != null) {
            String remoteAddr = remoteAddress.getAddress().getHostAddress();
            this.write(updated, X_FORWARDED_FOR_HEADER, remoteAddr, this.isForAppend());
        }
        String proto = request.uri().getScheme();
        if (this.isProtoEnabled()) {
            this.write(updated, X_FORWARDED_PROTO_HEADER, proto, this.isProtoAppend());
        }
        if (this.isPrefixEnabled()) {
            Iterable originalUris = null;
            URI requestUri = null;
            if (originalUris != null && requestUri != null) {
                originalUris.forEach(originalUri -> {
                    if (originalUri != null && originalUri.getPath() != null) {
                        String prefix = originalUri.getPath();
                        String originalUriPath = this.stripTrailingSlash((URI)originalUri);
                        String requestUriPath = this.stripTrailingSlash(requestUri);
                        this.updateRequest(updated, (URI)originalUri, originalUriPath, requestUriPath);
                    }
                });
            }
        }
        if (this.isPortEnabled()) {
            String port = String.valueOf(request.uri().getPort());
            if (request.uri().getPort() < 0) {
                port = String.valueOf(this.getDefaultPort(proto));
            }
            this.write(updated, X_FORWARDED_PORT_HEADER, port, this.isPortAppend());
        }
        if (this.isHostEnabled()) {
            String host = this.toHostHeader(request);
            this.write(updated, X_FORWARDED_HOST_HEADER, host, this.isHostAppend());
        }
        return updated;
    }

    private void updateRequest(HttpHeaders updated, URI originalUri, String originalUriPath, String requestUriPath) {
        String prefix;
        if (requestUriPath != null && originalUriPath.endsWith(requestUriPath) && (prefix = XForwardedRequestHeadersFilter.substringBeforeLast(originalUriPath, requestUriPath)) != null && prefix.length() > 0 && prefix.length() <= originalUri.getPath().length()) {
            this.write(updated, X_FORWARDED_PREFIX_HEADER, prefix, this.isPrefixAppend());
        }
    }

    private static String substringBeforeLast(String str, String separator) {
        if (ObjectUtils.isEmpty((Object)str) || ObjectUtils.isEmpty((Object)separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private void write(HttpHeaders headers, String name, String value, boolean append) {
        if (value == null) {
            return;
        }
        if (append) {
            headers.add(name, value);
            List values = headers.get((Object)name);
            String delimitedValue = StringUtils.collectionToCommaDelimitedString((Collection)values);
            headers.set(name, delimitedValue);
        } else {
            headers.set(name, value);
        }
    }

    private int getDefaultPort(String scheme) {
        return HTTPS_SCHEME.equals(scheme) ? 443 : 80;
    }

    private boolean hasHeader(ServerRequest request, String name) {
        HttpHeaders headers = request.headers().asHttpHeaders();
        return headers.containsKey((Object)name) && StringUtils.hasLength((String)headers.getFirst(name));
    }

    private String toHostHeader(ServerRequest request) {
        int port = request.uri().getPort();
        String host = request.uri().getHost();
        String scheme = request.uri().getScheme();
        if (port < 0 || port == 80 && HTTP_SCHEME.equals(scheme) || port == 443 && HTTPS_SCHEME.equals(scheme)) {
            return host;
        }
        return host + ":" + port;
    }

    private String stripTrailingSlash(URI uri) {
        if (uri.getPath().endsWith("/")) {
            return uri.getPath().substring(0, uri.getPath().length() - 1);
        }
        return uri.getPath();
    }
}

