/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.gateway.server.mvc.common.Configurable;
import org.springframework.cloud.gateway.server.mvc.common.HttpStatusHolder;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.common.Shortcut;
import org.springframework.cloud.gateway.server.mvc.filter.SimpleFilterSupplier;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayServerResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class CircuitBreakerFilterFunctions {
    private CircuitBreakerFilterFunctions() {
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> circuitBreaker(String id) {
        return CircuitBreakerFilterFunctions.circuitBreaker((CircuitBreakerConfig config) -> config.setId(id));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> circuitBreaker(String id, URI fallbackUri) {
        return CircuitBreakerFilterFunctions.circuitBreaker((CircuitBreakerConfig config) -> config.setId(id).setFallbackUri(fallbackUri));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> circuitBreaker(String id, String fallbackPath) {
        return CircuitBreakerFilterFunctions.circuitBreaker((CircuitBreakerConfig config) -> config.setId(id).setFallbackPath(fallbackPath));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> circuitBreaker(Consumer<CircuitBreakerConfig> configConsumer) {
        CircuitBreakerConfig config = new CircuitBreakerConfig();
        configConsumer.accept(config);
        return CircuitBreakerFilterFunctions.circuitBreaker(config);
    }

    @Shortcut(value={"id"})
    @Configurable
    public static HandlerFilterFunction<ServerResponse, ServerResponse> circuitBreaker(CircuitBreakerConfig config) {
        Set failureStatuses = config.getStatusCodes().stream().map(status -> HttpStatusHolder.valueOf(status).resolve()).collect(Collectors.toSet());
        return (request, next) -> {
            CircuitBreakerFactory circuitBreakerFactory = (CircuitBreakerFactory)MvcUtils.getApplicationContext(request).getBean(CircuitBreakerFactory.class);
            CircuitBreaker circuitBreaker = circuitBreakerFactory.create(config.getId());
            return (ServerResponse)circuitBreaker.run(() -> {
                try {
                    ServerResponse serverResponse = next.handle(request);
                    if (failureStatuses.contains(serverResponse.statusCode())) {
                        throw new CircuitBreakerStatusCodeException(serverResponse.statusCode());
                    }
                    return serverResponse;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, throwable -> {
                if (!StringUtils.hasText((String)config.getFallbackPath())) {
                    if (throwable instanceof TimeoutException) {
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT, throwable.getMessage(), throwable);
                    }
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, throwable.getMessage(), throwable);
                }
                MvcUtils.putAttribute(request, MvcUtils.CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR, throwable);
                return GatewayServerResponse.ok().build((httpServletRequest, httpServletResponse) -> {
                    try {
                        String expandedFallback = MvcUtils.expand(request, config.getFallbackPath());
                        request.servletRequest().getServletContext().getRequestDispatcher(expandedFallback).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                        return null;
                    }
                    catch (ServletException | IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            });
        };
    }

    public static class CircuitBreakerConfig {
        private String id;
        private String fallbackPath;
        private Set<String> statusCodes = new HashSet<String>();

        public String getId() {
            return this.id;
        }

        public CircuitBreakerConfig setId(String id) {
            this.id = id;
            return this;
        }

        public String getFallbackPath() {
            return this.fallbackPath;
        }

        public CircuitBreakerConfig setFallbackUri(String fallbackUri) {
            Assert.notNull((Object)fallbackUri, (String)"fallbackUri String may not be null");
            this.setFallbackUri(URI.create(fallbackUri));
            return this;
        }

        public CircuitBreakerConfig setFallbackUri(URI fallbackUri) {
            if (fallbackUri != null) {
                Assert.isTrue((boolean)fallbackUri.getScheme().equalsIgnoreCase("forward"), () -> "Scheme must be forward, but is " + fallbackUri.getScheme());
                this.fallbackPath = fallbackUri.getPath();
            } else {
                this.fallbackPath = null;
            }
            return this;
        }

        public CircuitBreakerConfig setFallbackPath(String fallbackPath) {
            this.fallbackPath = fallbackPath;
            return this;
        }

        public Set<String> getStatusCodes() {
            return this.statusCodes;
        }

        public CircuitBreakerConfig setStatusCodes(String ... statusCodes) {
            return this.setStatusCodes(new LinkedHashSet<String>(Arrays.asList(statusCodes)));
        }

        public CircuitBreakerConfig setStatusCodes(Set<String> statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }
    }

    public static class CircuitBreakerStatusCodeException
    extends ResponseStatusException {
        public CircuitBreakerStatusCodeException(HttpStatusCode statusCode) {
            super(statusCode);
        }
    }

    public static class FilterSupplier
    extends SimpleFilterSupplier {
        public FilterSupplier() {
            super(CircuitBreakerFilterFunctions.class);
        }
    }
}

