/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.security.Principal;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.common.Shortcut;
import org.springframework.cloud.gateway.server.mvc.filter.SimpleFilterSupplier;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class TokenRelayFilterFunctions {
    private TokenRelayFilterFunctions() {
    }

    @Shortcut
    public static HandlerFilterFunction<ServerResponse, ServerResponse> tokenRelay() {
        return (request, next) -> {
            Principal principle = request.servletRequest().getUserPrincipal();
            if (principle instanceof OAuth2AuthenticationToken) {
                OAuth2AuthenticationToken token = (OAuth2AuthenticationToken)principle;
                String clientRegistrationId = token.getAuthorizedClientRegistrationId();
                OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)clientRegistrationId).principal((Authentication)token).build();
                OAuth2AuthorizedClientManager clientManager = (OAuth2AuthorizedClientManager)MvcUtils.getApplicationContext(request).getBean(OAuth2AuthorizedClientManager.class);
                OAuth2AuthorizedClient authorizedClient = clientManager.authorize(authorizeRequest);
                OAuth2AccessToken accessToken = authorizedClient.getAccessToken();
                ServerRequest modified = ServerRequest.from((ServerRequest)request).headers(httpHeaders -> httpHeaders.setBearerAuth(accessToken.getTokenValue())).build();
                return next.handle(modified);
            }
            return next.handle(request);
        };
    }

    public static class FilterSupplier
    extends SimpleFilterSupplier {
        public FilterSupplier() {
            super(TokenRelayFilterFunctions.class);
        }
    }
}

