/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.springframework.core.NestedRuntimeException;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.NeverRetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.retry.support.RetryTemplateBuilder;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class RetryFilterFunctions {
    private RetryFilterFunctions() {
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> retry(int retries) {
        return RetryFilterFunctions.retry(config -> config.setRetries(retries));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> retry(Consumer<RetryConfig> configConsumer) {
        RetryConfig config = new RetryConfig();
        configConsumer.accept(config);
        RetryTemplateBuilder retryTemplateBuilder = RetryTemplate.builder();
        CompositeRetryPolicy compositeRetryPolicy = new CompositeRetryPolicy();
        HashMap retryableExceptions = new HashMap();
        config.getExceptions().forEach(exception -> retryableExceptions.put(exception, true));
        SimpleRetryPolicy simpleRetryPolicy = new SimpleRetryPolicy(config.getRetries(), retryableExceptions);
        compositeRetryPolicy.setPolicies(Arrays.asList(new RetryPolicy[]{simpleRetryPolicy, new HttpRetryPolicy(config)}).toArray(new RetryPolicy[0]));
        RetryTemplate retryTemplate = retryTemplateBuilder.customPolicy((RetryPolicy)compositeRetryPolicy).build();
        return (request, next) -> (ServerResponse)retryTemplate.execute(context -> {
            ServerResponse serverResponse = next.handle(request);
            if (RetryFilterFunctions.isRetryableStatusCode(serverResponse.statusCode(), config) && RetryFilterFunctions.isRetryableMethod(request.method(), config)) {
                throw new RetryException(request, serverResponse);
            }
            return serverResponse;
        });
    }

    private static boolean isRetryableStatusCode(HttpStatusCode httpStatus, RetryConfig config) {
        return config.getSeries().stream().anyMatch(series -> HttpStatus.Series.resolve((int)httpStatus.value()) == series);
    }

    private static boolean isRetryableMethod(HttpMethod method, RetryConfig config) {
        return config.methods.contains(method);
    }

    public static class RetryConfig {
        private int retries = 3;
        private Set<HttpStatus.Series> series = new HashSet<HttpStatus.Series>(List.of(HttpStatus.Series.SERVER_ERROR));
        private Set<Class<? extends Throwable>> exceptions = new HashSet<Class<RetryException>>(List.of(IOException.class, TimeoutException.class, RetryException.class));
        private Set<HttpMethod> methods = new HashSet<HttpMethod>(List.of(HttpMethod.GET));

        public int getRetries() {
            return this.retries;
        }

        public RetryConfig setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public Set<HttpStatus.Series> getSeries() {
            return this.series;
        }

        public RetryConfig setSeries(Set<HttpStatus.Series> series) {
            this.series = series;
            return this;
        }

        public RetryConfig addSeries(HttpStatus.Series ... series) {
            this.series.addAll(Arrays.asList(series));
            return this;
        }

        public Set<Class<? extends Throwable>> getExceptions() {
            return this.exceptions;
        }

        public RetryConfig setExceptions(Set<Class<? extends Throwable>> exceptions) {
            this.exceptions = exceptions;
            return this;
        }

        public RetryConfig addExceptions(Class<? extends Throwable> ... exceptions) {
            this.exceptions.addAll(Arrays.asList(exceptions));
            return this;
        }

        public Set<HttpMethod> getMethods() {
            return this.methods;
        }

        public RetryConfig setMethods(Set<HttpMethod> methods) {
            this.methods = methods;
            return this;
        }

        public RetryConfig addMethods(HttpMethod ... methods) {
            this.methods.addAll(Arrays.asList(methods));
            return this;
        }
    }

    public static class HttpRetryPolicy
    extends NeverRetryPolicy {
        private final RetryConfig config;

        public HttpRetryPolicy(RetryConfig config) {
            this.config = config;
        }

        public boolean canRetry(RetryContext context) {
            Throwable throwable = context.getLastThrowable();
            if (throwable instanceof RetryException) {
                RetryException e = (RetryException)((Object)throwable);
                return RetryFilterFunctions.isRetryableStatusCode(e.getResponse().statusCode(), this.config) && RetryFilterFunctions.isRetryableMethod(e.getRequest().method(), this.config);
            }
            return super.canRetry(context);
        }
    }

    private static class RetryException
    extends NestedRuntimeException {
        private final ServerRequest request;
        private final ServerResponse response;

        RetryException(ServerRequest request, ServerResponse response) {
            super(null);
            this.request = request;
            this.response = response;
        }

        public ServerRequest getRequest() {
            return this.request;
        }

        public ServerResponse getResponse() {
            return this.response;
        }
    }
}

