/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.server.mvc.common.KeyValues;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.filter.BodyFilterFunctions;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public abstract class BeforeFilterFunctions {
    private static final Log log = LogFactory.getLog(BeforeFilterFunctions.class);
    private static final String REQUEST_HEADER_SIZE_ERROR_PREFIX = "Request Header/s size is larger than permissible limit (%s).";
    private static final String REQUEST_HEADER_SIZE_ERROR = " Request Header/s size for '%s' is %s.";
    private static final String REQUEST_SIZE_ERROR_MSG = "Request size is larger than permissible limit. Request size is %s where permissible limit is %s";
    public static final String CB_EXECUTION_EXCEPTION_TYPE = "Execution-Exception-Type";
    public static final String CB_EXECUTION_EXCEPTION_MESSAGE = "Execution-Exception-Message";
    public static final String CB_ROOT_CAUSE_EXCEPTION_TYPE = "Root-Cause-Exception-Type";
    public static final String CB_ROOT_CAUSE_EXCEPTION_MESSAGE = "Root-Cause-Exception-Message";

    private BeforeFilterFunctions() {
    }

    public static Function<ServerRequest, ServerRequest> adaptCachedBody() {
        return BodyFilterFunctions.adaptCachedBody();
    }

    public static Function<ServerRequest, ServerRequest> addRequestHeader(String name, String ... values) {
        return request -> {
            String[] expandedValues = MvcUtils.expandMultiple(request, values);
            return ServerRequest.from((ServerRequest)request).header(name, expandedValues).build();
        };
    }

    public static Function<ServerRequest, ServerRequest> addRequestHeadersIfNotPresent(String ... values) {
        List<KeyValues.KeyValue> keyValues = Arrays.stream(values).map(KeyValues.KeyValue::valueOf).toList();
        return BeforeFilterFunctions.addRequestHeadersIfNotPresent(keyValues);
    }

    public static Function<ServerRequest, ServerRequest> addRequestHeadersIfNotPresent(List<KeyValues.KeyValue> keyValues) {
        HttpHeaders newHeaders = new HttpHeaders();
        keyValues.forEach(keyValue -> newHeaders.add(keyValue.getKey(), keyValue.getValue()));
        return request -> {
            ServerRequest.Builder requestBuilder = ServerRequest.from((ServerRequest)request);
            newHeaders.forEach((newHeaderName, newHeaderValues) -> {
                boolean headerIsMissingOrBlank = request.headers().asHttpHeaders().getOrEmpty(newHeaderName).stream().allMatch(h -> !StringUtils.hasText((String)h));
                if (headerIsMissingOrBlank) {
                    requestBuilder.headers(httpHeaders -> {
                        List<String> expandedValues = MvcUtils.expandMultiple(request, newHeaderValues);
                        httpHeaders.addAll(newHeaderName, expandedValues);
                    });
                }
            });
            return requestBuilder.build();
        };
    }

    public static Function<ServerRequest, ServerRequest> addRequestParameter(String name, String ... values) {
        return request -> {
            String[] expandedValues = MvcUtils.expandMultiple(request, values);
            return ServerRequest.from((ServerRequest)request).param(name, expandedValues).build();
        };
    }

    public static Function<ServerRequest, ServerRequest> fallbackHeaders() {
        return BeforeFilterFunctions.fallbackHeaders(config -> {});
    }

    public static Function<ServerRequest, ServerRequest> fallbackHeaders(Consumer<FallbackHeadersConfig> configConsumer) {
        FallbackHeadersConfig config = new FallbackHeadersConfig();
        configConsumer.accept(config);
        return request -> request.attribute(MvcUtils.CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR).map(Throwable.class::cast).map(throwable -> ServerRequest.from((ServerRequest)request).headers(httpHeaders -> {
            Throwable rootCause;
            httpHeaders.add(config.getExecutionExceptionTypeHeaderName(), throwable.getClass().getName());
            if (throwable.getMessage() != null) {
                httpHeaders.add(config.getExecutionExceptionMessageHeaderName(), throwable.getMessage());
            }
            if ((rootCause = BeforeFilterFunctions.getRootCause(throwable)) != null) {
                httpHeaders.add(config.getRootCauseExceptionTypeHeaderName(), rootCause.getClass().getName());
                if (rootCause.getMessage() != null) {
                    httpHeaders.add(config.getRootCauseExceptionMessageHeaderName(), rootCause.getMessage());
                }
            }
        }).build()).orElse((ServerRequest)request);
    }

    private static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = BeforeFilterFunctions.getThrowableList(throwable);
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static Function<ServerRequest, ServerRequest> mapRequestHeader(String fromHeader, String toHeader) {
        return request -> {
            if (request.headers().asHttpHeaders().containsKey((Object)fromHeader)) {
                List values = request.headers().header(fromHeader);
                return ServerRequest.from((ServerRequest)request).header(toHeader, values.toArray(new String[0])).build();
            }
            return request;
        };
    }

    public static <T, R> Function<ServerRequest, ServerRequest> modifyRequestBody(Class<T> inClass, Class<R> outClass, String newContentType, BodyFilterFunctions.RewriteFunction<T, R> rewriteFunction) {
        return BodyFilterFunctions.modifyRequestBody(inClass, outClass, newContentType, rewriteFunction);
    }

    public static Function<ServerRequest, ServerRequest> prefixPath(String prefix) {
        UriTemplate uriTemplate = new UriTemplate(prefix);
        return request -> {
            Map<String, Object> uriVariables = MvcUtils.getUriTemplateVariables(request);
            URI uri = uriTemplate.expand(uriVariables);
            String newPath = uri.getRawPath() + request.uri().getRawPath();
            URI prefixedUri = UriComponentsBuilder.fromUri((URI)request.uri()).replacePath(newPath).build().toUri();
            return ServerRequest.from((ServerRequest)request).uri(prefixedUri).build();
        };
    }

    public static Function<ServerRequest, ServerRequest> preserveHostHeader() {
        return request -> {
            request.attributes().put(MvcUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, true);
            return request;
        };
    }

    public static Function<ServerRequest, ServerRequest> removeRequestHeader(String name) {
        return request -> ServerRequest.from((ServerRequest)request).headers(httpHeaders -> httpHeaders.remove((Object)name)).build();
    }

    public static Function<ServerRequest, ServerRequest> removeRequestParameter(String name) {
        return request -> {
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap((Map)request.params());
            queryParams.remove((Object)name);
            URI newUri = UriComponentsBuilder.fromUri((URI)request.uri()).replaceQueryParams(CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)queryParams)).build().toUri();
            return ServerRequest.from((ServerRequest)request).params(params -> params.remove((Object)name)).uri(newUri).build();
        };
    }

    public static Function<ServerRequest, ServerRequest> requestHeaderSize(String maxSize) {
        return BeforeFilterFunctions.requestHeaderSize(DataSize.parse((CharSequence)maxSize));
    }

    public static Function<ServerRequest, ServerRequest> requestHeaderSize(String maxSize, String errorHeaderName) {
        return BeforeFilterFunctions.requestHeaderSize(DataSize.parse((CharSequence)maxSize), errorHeaderName);
    }

    public static Function<ServerRequest, ServerRequest> requestHeaderSize(DataSize maxSize) {
        return BeforeFilterFunctions.requestHeaderSize(maxSize, "errorMessage");
    }

    public static Function<ServerRequest, ServerRequest> requestHeaderSize(DataSize maxSize, final String errorHeaderName) {
        Assert.notNull((Object)maxSize, (String)"maxSize may not be null");
        Assert.isTrue((maxSize.toBytes() > 0L ? 1 : 0) != 0, (String)"maxSize must be greater than 0");
        Assert.hasText((String)errorHeaderName, (String)"errorHeaderName may not be empty");
        return request -> {
            HashMap<String, Long> longHeaders = new HashMap<String, Long>();
            request.headers().asHttpHeaders().forEach((key, values) -> {
                long headerSizeInBytes = 0L;
                headerSizeInBytes += (long)key.getBytes().length;
                for (String value : values) {
                    headerSizeInBytes += (long)value.getBytes().length;
                }
                if (headerSizeInBytes > maxSize.toBytes()) {
                    longHeaders.put((String)key, headerSizeInBytes);
                }
            });
            if (!longHeaders.isEmpty()) {
                final StringBuilder errorMessage = new StringBuilder(String.format(REQUEST_HEADER_SIZE_ERROR_PREFIX, maxSize));
                longHeaders.forEach((header, size) -> errorMessage.append(String.format(REQUEST_HEADER_SIZE_ERROR, header, DataSize.of((long)size, (DataUnit)DataUnit.BYTES))));
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.REQUEST_HEADER_FIELDS_TOO_LARGE, errorMessage.toString()){

                    public HttpHeaders getHeaders() {
                        HttpHeaders httpHeaders = new HttpHeaders();
                        httpHeaders.add(errorHeaderName, errorMessage.toString());
                        return httpHeaders;
                    }
                };
            }
            return request;
        };
    }

    public static Function<ServerRequest, ServerRequest> requestHeaderToRequestUri(String name) {
        return request -> {
            if (request.headers().asHttpHeaders().containsKey((Object)name)) {
                String newUri = request.headers().firstHeader(name);
                try {
                    MvcUtils.setRequestUrl(request, new URI(newUri));
                }
                catch (URISyntaxException e) {
                    log.info((Object)LogMessage.format((String)"Request url is invalid : url=%s", (Object)newUri), (Throwable)e);
                }
            }
            return request;
        };
    }

    public static Function<ServerRequest, ServerRequest> requestSize(String maxSize) {
        return BeforeFilterFunctions.requestSize(DataSize.parse((CharSequence)maxSize));
    }

    public static Function<ServerRequest, ServerRequest> requestSize(DataSize maxSize) {
        Assert.notNull((Object)maxSize, (String)"maxSize may not be null");
        Assert.isTrue((maxSize.toBytes() > 0L ? 1 : 0) != 0, (String)"maxSize must be greater than 0");
        return request -> {
            long contentLength;
            if (request.headers().asHttpHeaders().containsKey((Object)"Content-Length") && (contentLength = request.headers().asHttpHeaders().getContentLength()) > maxSize.toBytes()) {
                final String errorMessage = String.format(REQUEST_SIZE_ERROR_MSG, DataSize.ofBytes((long)contentLength), maxSize);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE, errorMessage){

                    public HttpHeaders getHeaders() {
                        HttpHeaders httpHeaders = new HttpHeaders();
                        httpHeaders.add("errorMessage", errorMessage);
                        return httpHeaders;
                    }
                };
            }
            return request;
        };
    }

    public static Function<ServerRequest, ServerRequest> rewritePath(String regexp, String replacement) {
        String normalizedReplacement = replacement.replace("$\\", "$");
        Pattern pattern = Pattern.compile(regexp);
        return request -> {
            String path = request.uri().getRawPath();
            String newPath = pattern.matcher(path).replaceAll(normalizedReplacement);
            URI rewrittenUri = UriComponentsBuilder.fromUri((URI)request.uri()).replacePath(newPath).build().toUri();
            ServerRequest modified = ServerRequest.from((ServerRequest)request).uri(rewrittenUri).build();
            MvcUtils.setRequestUrl(modified, modified.uri());
            return modified;
        };
    }

    public static Function<ServerRequest, ServerRequest> routeId(String routeId) {
        return request -> {
            MvcUtils.setRouteId(request, routeId);
            return request;
        };
    }

    public static Function<ServerRequest, ServerRequest> setPath(String path) {
        UriTemplate uriTemplate = new UriTemplate(path);
        return request -> {
            Map<String, Object> uriVariables = MvcUtils.getUriTemplateVariables(request);
            URI uri = uriTemplate.expand(uriVariables);
            String newPath = uri.getRawPath();
            URI prefixedUri = UriComponentsBuilder.fromUri((URI)request.uri()).replacePath(newPath).build().toUri();
            return ServerRequest.from((ServerRequest)request).uri(prefixedUri).build();
        };
    }

    public static Function<ServerRequest, ServerRequest> setRequestHeader(String name, String value) {
        return request -> {
            String expandedValue = MvcUtils.expand(request, value);
            return ServerRequest.from((ServerRequest)request).headers(httpHeaders -> httpHeaders.set(name, expandedValue)).build();
        };
    }

    public static Function<ServerRequest, ServerRequest> setRequestHostHeader(String host) {
        return request -> {
            String expandedValue = MvcUtils.expand(request, host);
            ServerRequest modified = ServerRequest.from((ServerRequest)request).headers(httpHeaders -> {
                httpHeaders.remove((Object)"Host");
                httpHeaders.set("Host", expandedValue);
            }).build();
            modified.attributes().put(MvcUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, true);
            return modified;
        };
    }

    public static Function<ServerRequest, ServerRequest> stripPrefix() {
        return BeforeFilterFunctions.stripPrefix(1);
    }

    public static Function<ServerRequest, ServerRequest> stripPrefix(int parts) {
        return request -> {
            String path = request.uri().getRawPath();
            String[] originalParts = StringUtils.tokenizeToStringArray((String)path, (String)"/");
            StringBuilder newPath = new StringBuilder("/");
            for (int i = 0; i < originalParts.length; ++i) {
                if (i < parts) continue;
                if (newPath.length() > 1) {
                    newPath.append('/');
                }
                newPath.append(originalParts[i]);
            }
            if (newPath.length() > 1 && path.endsWith("/")) {
                newPath.append('/');
            }
            URI prefixedUri = UriComponentsBuilder.fromUri((URI)request.uri()).replacePath(newPath.toString()).build().toUri();
            return ServerRequest.from((ServerRequest)request).uri(prefixedUri).build();
        };
    }

    public static class FallbackHeadersConfig {
        private String executionExceptionTypeHeaderName = "Execution-Exception-Type";
        private String executionExceptionMessageHeaderName = "Execution-Exception-Message";
        private String rootCauseExceptionTypeHeaderName = "Root-Cause-Exception-Type";
        private String rootCauseExceptionMessageHeaderName = "Root-Cause-Exception-Message";

        public String getExecutionExceptionTypeHeaderName() {
            return this.executionExceptionTypeHeaderName;
        }

        public void setExecutionExceptionTypeHeaderName(String executionExceptionTypeHeaderName) {
            this.executionExceptionTypeHeaderName = executionExceptionTypeHeaderName;
        }

        public String getExecutionExceptionMessageHeaderName() {
            return this.executionExceptionMessageHeaderName;
        }

        public void setExecutionExceptionMessageHeaderName(String executionExceptionMessageHeaderName) {
            this.executionExceptionMessageHeaderName = executionExceptionMessageHeaderName;
        }

        public String getRootCauseExceptionTypeHeaderName() {
            return this.rootCauseExceptionTypeHeaderName;
        }

        public void setRootCauseExceptionTypeHeaderName(String rootCauseExceptionTypeHeaderName) {
            this.rootCauseExceptionTypeHeaderName = rootCauseExceptionTypeHeaderName;
        }

        public String getRootCauseExceptionMessageHeaderName() {
            return this.rootCauseExceptionMessageHeaderName;
        }

        public void setRootCauseExceptionMessageHeaderName(String rootCauseExceptionMessageHeaderName) {
            this.rootCauseExceptionMessageHeaderName = rootCauseExceptionMessageHeaderName;
        }
    }
}

