/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ServerlessHttpServletResponse
implements HttpServletResponse {
    private static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private String defaultCharacterEncoding;
    private String characterEncoding;
    private final ByteArrayOutputStream content;
    private final ServletOutputStream outputStream;
    private String contentType;
    private int bufferSize;
    private Locale locale;
    private final List<Cookie> cookies;
    private final HttpHeaders headers;
    private int status;
    private ResponsePrintWriter writer;
    @Nullable
    private String errorMessage;

    public ServerlessHttpServletResponse() {
        this.characterEncoding = this.defaultCharacterEncoding = "ISO-8859-1";
        this.content = new ByteArrayOutputStream(1024);
        this.outputStream = new ResponseServletOutputStream();
        this.bufferSize = 4096;
        this.locale = Locale.getDefault();
        this.cookies = new ArrayList<Cookie>();
        this.headers = new HttpHeaders();
        this.status = 200;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter targetWriter = new OutputStreamWriter((OutputStream)this.content, this.getCharacterEncoding());
            this.writer = new ResponsePrintWriter(targetWriter);
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        return this.content.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        return this.content.toString(this.getCharacterEncoding());
    }

    public String getContentAsString(Charset fallbackCharset) throws UnsupportedEncodingException {
        return this.content.toString(this.getCharacterEncoding());
    }

    public void setContentLength(int contentLength) {
        throw new UnsupportedOperationException();
    }

    public void setContentLengthLong(long len) {
    }

    public void setContentType(@Nullable String contentType) {
        this.contentType = contentType;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() {
    }

    public void resetBuffer() {
        Assert.state((!this.isCommitted() ? 1 : 0) != 0, (String)"Cannot reset buffer - response is already committed");
        this.content.reset();
    }

    public boolean isCommitted() {
        return this.writer == null ? false : this.writer.commited;
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = this.defaultCharacterEncoding;
        this.contentType = null;
        this.locale = Locale.getDefault();
        this.cookies.clear();
        this.headers.clear();
        this.status = 200;
        this.errorMessage = null;
    }

    public void setLocale(@Nullable Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.headers.add("Content-Language", locale.toLanguageTag());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Cookie getCookie(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey((Object)name);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Nullable
    public String getHeader(String name) {
        return this.headers.containsKey((Object)name) ? (String)this.headers.get((Object)name).get(0) : null;
    }

    public List<String> getHeaders(String name) {
        return this.headers.get((Object)name);
    }

    @Nullable
    public Object getHeaderValue(String name) {
        return this.headers.containsKey((Object)name) ? this.headers.get((Object)name).get(0) : null;
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int status, String errorMessage) throws IOException {
        Assert.state((!this.isCommitted() ? 1 : 0) != 0, (String)"Cannot set error status - response is already committed");
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public void sendError(int status) throws IOException {
        Assert.state((!this.isCommitted() ? 1 : 0) != 0, (String)"Cannot set error status - response is already committed");
        this.status = status;
    }

    public void sendRedirect(String url) throws IOException {
        Assert.state((!this.isCommitted() ? 1 : 0) != 0, (String)"Cannot send redirect - response is already committed");
        Assert.notNull((Object)url, (String)"Redirect URL must not be null");
        this.setHeader("Location", url);
        this.setStatus(302);
    }

    @Nullable
    public String getRedirectedUrl() {
        return this.getHeader("Location");
    }

    public void setDateHeader(String name, long value) {
        this.headers.set(name, this.formatDate(value));
    }

    public void addDateHeader(String name, long value) {
        this.headers.add(name, this.formatDate(value));
    }

    private String formatDate(long date) {
        return this.newDateFormat().format(new Date(date));
    }

    private DateFormat newDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        return dateFormat;
    }

    public void setHeader(String name, @Nullable String value) {
        this.headers.set(name, value);
    }

    public void addHeader(String name, @Nullable String value) {
        this.headers.add(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.set(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.headers.add(name, String.valueOf(value));
    }

    public void setStatus(int status) {
        if (!this.isCommitted()) {
            this.status = status;
        }
    }

    public int getStatus() {
        return this.status;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    private class ResponseServletOutputStream
    extends ServletOutputStream {
        private WriteListener listener;

        private ResponseServletOutputStream() {
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            if (writeListener != null) {
                try {
                    writeListener.onWritePossible();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.listener = writeListener;
            }
        }

        public void write(int b) throws IOException {
            block2: {
                try {
                    ServerlessHttpServletResponse.this.content.write(b);
                }
                catch (Exception e) {
                    if (this.listener == null) break block2;
                    this.listener.onError((Throwable)e);
                }
            }
        }

        public void close() throws IOException {
            super.close();
            ServerlessHttpServletResponse.this.flushBuffer();
        }
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        private boolean commited;

        ResponsePrintWriter(Writer out) {
            super(out, true);
        }

        @Override
        public void write(char[] buf, int off, int len) {
            super.write(buf, off, len);
            super.flush();
            this.commited = true;
        }

        @Override
        public void write(String s, int off, int len) {
            super.write(s, off, len);
            super.flush();
            this.commited = true;
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.flush();
            this.commited = true;
        }

        @Override
        public void flush() {
            super.flush();
            this.commited = true;
        }

        @Override
        public void close() {
            super.flush();
            super.close();
            this.commited = true;
        }
    }
}

