/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogAutoConfiguration;
import org.springframework.cloud.function.context.config.JsonMessageConverter;
import org.springframework.cloud.function.context.config.SmartCompositeMessageConverter;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.utils.PrimitiveTypesFromStringMessageConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ContextFunctionCatalogInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    public static final String IGNORE_BACKGROUNDPREINITIALIZER_PROPERTY_NAME = "spring.backgroundpreinitializer.ignore";
    public static boolean enabled = true;

    public void initialize(GenericApplicationContext applicationContext) {
        if (enabled && ((Boolean)applicationContext.getEnvironment().getProperty("spring.functional.enabled", Boolean.class, (Object)false)).booleanValue()) {
            ContextFunctionCatalogBeanRegistrar registrar = new ContextFunctionCatalogBeanRegistrar(applicationContext);
            applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)registrar);
        }
    }

    static class ContextFunctionCatalogBeanRegistrar
    implements BeanDefinitionRegistryPostProcessor {
        private GenericApplicationContext context;

        ContextFunctionCatalogBeanRegistrar(GenericApplicationContext applicationContext) {
            this.context = applicationContext;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            try {
                this.register(registry, (ConfigurableListableBeanFactory)this.context.getDefaultListableBeanFactory());
            }
            catch (BeansException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BeanCreationException("Cannot register from " + this.getClass(), (Throwable)e);
            }
        }

        protected void register(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory factory) throws Exception {
            this.performPreinitialization();
            if (this.context.getBeanFactory().getBeanNamesForType(PropertySourcesPlaceholderConfigurer.class, false, false).length == 0) {
                this.context.registerBean(PropertySourcesPlaceholderConfigurer.class, () -> PropertyPlaceholderAutoConfiguration.propertySourcesPlaceholderConfigurer(), new BeanDefinitionCustomizer[0]);
            }
            if (!this.context.getBeanFactory().containsBeanDefinition("org.springframework.context.annotation.internalConfigurationAnnotationProcessor")) {
                this.context.registerBean("org.springframework.context.annotation.internalConfigurationAnnotationProcessor", DummyProcessor.class, () -> new DummyProcessor(), new BeanDefinitionCustomizer[0]);
                AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)this.context);
            }
            ConfigurationPropertiesBindingPostProcessor.register((BeanDefinitionRegistry)registry);
            String preferredMapper = this.context.getEnvironment().getProperty("spring.cloud.function.preferred-json-mapper");
            if (ClassUtils.isPresent((String)"com.google.gson.Gson", null) && "gson".equals(preferredMapper)) {
                if (this.context.getBeanFactory().getBeanNamesForType(Gson.class, false, false).length == 0) {
                    this.context.registerBean(Gson.class, () -> new Gson(), new BeanDefinitionCustomizer[0]);
                }
                this.context.registerBean(JsonMapper.class, () -> new ContextFunctionCatalogAutoConfiguration.JsonMapperConfiguration().jsonMapper((ApplicationContext)this.context), new BeanDefinitionCustomizer[0]);
            } else if (ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", null)) {
                if (this.context.getBeanFactory().getBeanNamesForType(ObjectMapper.class, false, false).length == 0) {
                    this.context.registerBean(ObjectMapper.class, () -> new ObjectMapper(), new BeanDefinitionCustomizer[0]);
                }
                this.context.registerBean(JsonMapper.class, () -> new ContextFunctionCatalogAutoConfiguration.JsonMapperConfiguration().jsonMapper((ApplicationContext)this.context), new BeanDefinitionCustomizer[0]);
            }
            String basePackage = this.context.getEnvironment().getProperty("spring.cloud.function.scan.packages", "functions");
            if (((Boolean)this.context.getEnvironment().getProperty("spring.cloud.function.scan.enabled", Boolean.class, (Object)true)).booleanValue() && new ClassPathResource(basePackage.replace(".", "/")).exists()) {
                ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)this.context, false, (Environment)this.context.getEnvironment(), (ResourceLoader)this.context);
                scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Function.class));
                scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Supplier.class));
                scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Consumer.class));
                for (BeanDefinition bean : scanner.findCandidateComponents(basePackage)) {
                    String name = bean.getBeanClassName();
                    Class type = ClassUtils.resolveClassName((String)name, (ClassLoader)this.context.getClassLoader());
                    this.context.registerBeanDefinition(name, bean);
                    this.context.registerBean("registration_" + name, FunctionRegistration.class, () -> new FunctionRegistration<Object>(this.context.getBean(name), name).type(type), new BeanDefinitionCustomizer[0]);
                }
            }
            if (this.context.getBeanFactory().getBeanNamesForType(FunctionCatalog.class, false, false).length == 0) {
                this.context.registerBean(SimpleFunctionRegistry.class, () -> {
                    ArrayList<MessageConverter> messageConverters = new ArrayList<MessageConverter>();
                    JsonMapper jsonMapper = (JsonMapper)this.context.getBean(JsonMapper.class);
                    messageConverters.addAll(this.context.getBeansOfType(MessageConverter.class).values());
                    messageConverters.add((MessageConverter)new JsonMessageConverter(jsonMapper));
                    messageConverters.add((MessageConverter)new ByteArrayMessageConverter());
                    messageConverters.add((MessageConverter)new StringMessageConverter());
                    messageConverters.add((MessageConverter)new PrimitiveTypesFromStringMessageConverter((ConversionService)new DefaultConversionService()));
                    SmartCompositeMessageConverter messageConverter = new SmartCompositeMessageConverter(messageConverters);
                    DefaultConversionService conversionService = new DefaultConversionService();
                    return new SimpleFunctionRegistry((ConversionService)conversionService, messageConverter, (JsonMapper)this.context.getBean(JsonMapper.class));
                }, new BeanDefinitionCustomizer[0]);
                this.context.registerBean(FunctionProperties.class, () -> new FunctionProperties(), new BeanDefinitionCustomizer[0]);
                this.context.registerBean(FunctionRegistrationPostProcessor.class, () -> new FunctionRegistrationPostProcessor((ObjectProvider<FunctionRegistration>)this.context.getAutowireCapableBeanFactory().getBeanProvider(FunctionRegistration.class)), new BeanDefinitionCustomizer[0]);
            }
        }

        private void performPreinitialization() {
            if (Boolean.getBoolean(ContextFunctionCatalogInitializer.IGNORE_BACKGROUNDPREINITIALIZER_PROPERTY_NAME)) {
                return;
            }
            try {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        this.runSafely(() -> new DefaultFormattingConversionService());
                    }

                    public void runSafely(Runnable runnable) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }, "background-preinit");
                thread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private class FunctionRegistrationPostProcessor
        implements BeanPostProcessor {
            private final ObjectProvider<FunctionRegistration> functions;

            FunctionRegistrationPostProcessor(ObjectProvider<FunctionRegistration> functions) {
                this.functions = functions;
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof FunctionRegistry) {
                    FunctionRegistry catalog = (FunctionRegistry)bean;
                    for (FunctionRegistration registration : this.functions) {
                        Assert.notEmpty(registration.getNames(), (String)"FunctionRegistration must define at least one name. Was empty");
                        if (registration.getType() == null) {
                            throw new IllegalStateException("You need an explicit type for the function: " + registration.getNames());
                        }
                        catalog.register(registration);
                    }
                }
                return bean;
            }
        }
    }

    public static class DummyProcessor {
        public void setMetadataReaderFactory(MetadataReaderFactory obj) {
        }
    }
}

