/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.config.FunctionContextUtils;

public class FunctionTypeProcessor
implements BeanFactoryInitializationAotProcessor {
    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        HashSet typeHints = new HashSet();
        String[] names = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < names.length; ++i) {
            String beanName = names[i];
            Class beanClass = beanFactory.getType(beanName);
            if (!this.isFunction(beanClass)) continue;
            Type functionType = FunctionTypeUtils.discoverFunctionTypeFromClass(beanClass);
            if (!(functionType instanceof ParameterizedType)) {
                functionType = FunctionContextUtils.findType(beanFactory, beanName);
            }
            this.registerAllGenericTypes((ParameterizedType)functionType, typeHints);
        }
        return new ReflectiveProcessorBeanFactoryInitializationAotContribution((Class[])typeHints.toArray(Class[]::new));
    }

    private void registerAllGenericTypes(ParameterizedType type, Set<Class<?>> typeHints) {
        Type[] types = type.getActualTypeArguments();
        for (int i = 0; i < types.length; ++i) {
            Type functionParameterType = types[i];
            String name = functionParameterType.getTypeName();
            if (!this.isCoreJavaType(name)) {
                typeHints.add(FunctionTypeUtils.getRawType(functionParameterType));
            }
            if (!(functionParameterType instanceof ParameterizedType)) continue;
            this.registerAllGenericTypes((ParameterizedType)functionParameterType, typeHints);
        }
    }

    private boolean isCoreJavaType(String className) {
        return className.startsWith("java.") || className.startsWith("javax.");
    }

    private boolean isFunction(Class<?> beanType) {
        return Function.class.isAssignableFrom(beanType) || Consumer.class.isAssignableFrom(beanType) || Supplier.class.isAssignableFrom(beanType);
    }

    private static final class ReflectiveProcessorBeanFactoryInitializationAotContribution
    implements BeanFactoryInitializationAotContribution {
        private final Class<?>[] typeHints;

        private ReflectiveProcessorBeanFactoryInitializationAotContribution(Class<?>[] typeHints) {
            this.typeHints = typeHints;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            RuntimeHints runtimeHints = generationContext.getRuntimeHints();
            for (int i = 0; i < this.typeHints.length; ++i) {
                runtimeHints.reflection().registerType(this.typeHints[i], new MemberCategory[]{MemberCategory.PUBLIC_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
            }
        }
    }
}

