/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.config;

import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.MessageRoutingCallback;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.DataBindingPropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RoutingFunction
implements Function<Object, Object> {
    public static final String FUNCTION_NAME = "functionRouter";
    public static final String DEFAULT_ROUTE_HANDLER = "defaultMessageRoutingHandler";
    private static Log logger = LogFactory.getLog(RoutingFunction.class);
    private final StandardEvaluationContext evalContext = new StandardEvaluationContext();
    private final SimpleEvaluationContext headerEvalContext = SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{DataBindingPropertyAccessor.forReadOnlyAccess()}).build();
    private final SpelExpressionParser spelParser = new SpelExpressionParser();
    private final FunctionCatalog functionCatalog;
    private final FunctionProperties functionProperties;
    private final MessageRoutingCallback routingCallback;

    public RoutingFunction(FunctionCatalog functionCatalog, FunctionProperties functionProperties) {
        this(functionCatalog, functionProperties, null, null);
    }

    public RoutingFunction(FunctionCatalog functionCatalog, Map<String, String> propertiesMap, BeanResolver beanResolver, MessageRoutingCallback routingCallback) {
        this(functionCatalog, RoutingFunction.extractIntoFunctionProperties(propertiesMap), beanResolver, routingCallback);
    }

    public RoutingFunction(FunctionCatalog functionCatalog, FunctionProperties functionProperties, BeanResolver beanResolver, MessageRoutingCallback routingCallback) {
        this.functionCatalog = functionCatalog;
        this.functionProperties = functionProperties;
        this.routingCallback = routingCallback;
        this.evalContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        this.evalContext.setBeanResolver(beanResolver);
    }

    private static FunctionProperties extractIntoFunctionProperties(Map<String, String> propertiesMap) {
        FunctionProperties functionProperties = new FunctionProperties();
        functionProperties.setDefinition(propertiesMap.get("spring.cloud.function.definition"));
        functionProperties.setRoutingExpression(propertiesMap.get("spring.cloud.function.routing-expression"));
        return functionProperties;
    }

    @Override
    public Object apply(Object input) {
        return this.route(input, input instanceof Publisher);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object route(Object input, boolean originalInputIsPublisher) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = null;
        if (input instanceof Message) {
            MessageRoutingCallback.FunctionRoutingResult routingResult;
            Message<?> message = (Message<?>)input;
            if (this.routingCallback != null && (routingResult = this.routingCallback.routingResult(message)) != null) {
                if (StringUtils.hasText((String)routingResult.getFunctionDefinition())) {
                    function = this.functionFromDefinition(routingResult.getFunctionDefinition());
                }
                if (routingResult.getMessage() != null) {
                    message = routingResult.getMessage();
                }
            }
            if (function == null) {
                if (StringUtils.hasText((String)((String)message.getHeaders().get((Object)"spring.cloud.function.definition")))) {
                    function = this.functionFromDefinition((String)message.getHeaders().get((Object)"spring.cloud.function.definition"));
                    if (function.isInputTypePublisher()) {
                        this.assertOriginalInputIsNotPublisher(originalInputIsPublisher);
                    }
                } else if (StringUtils.hasText((String)((String)message.getHeaders().get((Object)"spring.cloud.function.routing-expression")))) {
                    function = this.functionFromExpression((String)message.getHeaders().get((Object)"spring.cloud.function.routing-expression"), message, true);
                    if (function.isInputTypePublisher()) {
                        this.assertOriginalInputIsNotPublisher(originalInputIsPublisher);
                    }
                } else if (StringUtils.hasText((String)this.functionProperties.getRoutingExpression())) {
                    function = this.functionFromExpression(this.functionProperties.getRoutingExpression(), message);
                } else {
                    if (!StringUtils.hasText((String)this.functionProperties.getDefinition())) throw new IllegalStateException("Failed to establish route, since neither were provided: 'spring.cloud.function.definition' as Message header or as application property or 'spring.cloud.function.routing-expression' as application property. Incoming message: " + input);
                    function = this.functionFromDefinition(this.functionProperties.getDefinition());
                }
            }
        } else if (input instanceof Publisher) {
            if (StringUtils.hasText((String)this.functionProperties.getDefinition())) {
                function = this.functionFromDefinition(this.functionProperties.getDefinition());
            } else {
                if (!StringUtils.hasText((String)this.functionProperties.getRoutingExpression())) return input instanceof Mono ? Mono.from((Publisher)((Publisher)input)).map(v -> this.route(v, originalInputIsPublisher)) : Flux.from((Publisher)((Publisher)input)).map(v -> this.route(v, originalInputIsPublisher));
                function = this.functionFromExpression(this.functionProperties.getRoutingExpression(), input);
            }
        } else {
            this.assertOriginalInputIsNotPublisher(originalInputIsPublisher);
            if (StringUtils.hasText((String)this.functionProperties.getRoutingExpression())) {
                function = this.functionFromExpression(this.functionProperties.getRoutingExpression(), input);
            } else {
                if (!StringUtils.hasText((String)this.functionProperties.getDefinition())) throw new IllegalStateException("Failed to establish route, since neither were provided: 'spring.cloud.function.definition' as Message header or as application property or 'spring.cloud.function.routing-expression' as application property.");
                function = this.functionFromDefinition(this.functionProperties.getDefinition());
            }
        }
        if (!function.getTarget().equals(this)) return function.apply(input);
        throw new IllegalStateException("Failed to establish route, and routing to itself is not allowed as it creates a loop. Please provide: 'spring.cloud.function.definition' as Message header or as application property or 'spring.cloud.function.routing-expression' as application property.");
    }

    private void assertOriginalInputIsNotPublisher(boolean originalInputIsPublisher) {
        Assert.isTrue((!originalInputIsPublisher ? 1 : 0) != 0, (String)"Routing input of type Publisher is not supported per individual values (e.g., message header or POJO). Instead you should use 'spring.cloud.function.definition' or spring.cloud.function.routing-expression' as application properties.");
    }

    private SimpleFunctionRegistry.FunctionInvocationWrapper functionFromDefinition(String definition) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = this.resolveFunction(definition);
        Assert.notNull((Object)function, (String)("Failed to lookup function to route based on the value of 'spring.cloud.function.definition' property '" + this.functionProperties.getDefinition() + "'"));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Resolved function from provided [definition] property " + this.functionProperties.getDefinition()));
        }
        return function;
    }

    private SimpleFunctionRegistry.FunctionInvocationWrapper functionFromExpression(String routingExpression, Object input) {
        return this.functionFromExpression(routingExpression, input, false);
    }

    private SimpleFunctionRegistry.FunctionInvocationWrapper functionFromExpression(String routingExpression, Object input, boolean isViaHeader) {
        Expression expression = this.spelParser.parseExpression(routingExpression);
        if (input instanceof Message) {
            input = MessageUtils.toCaseInsensitiveHeadersStructure((Message)input);
        }
        String definition = isViaHeader ? (String)expression.getValue((EvaluationContext)this.headerEvalContext, input, String.class) : (String)expression.getValue((EvaluationContext)this.evalContext, input, String.class);
        Assert.hasText((String)definition, (String)("Failed to resolve function name based on routing expression '" + this.functionProperties.getRoutingExpression() + "'"));
        SimpleFunctionRegistry.FunctionInvocationWrapper function = this.resolveFunction(definition);
        Assert.notNull((Object)function, (String)("Failed to lookup function to route to based on the expression '" + this.functionProperties.getRoutingExpression() + "' which resolved to '" + definition + "' function definition."));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Resolved function from provided [routing-expression]  " + routingExpression));
        }
        return function;
    }

    private SimpleFunctionRegistry.FunctionInvocationWrapper resolveFunction(String definition) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.functionCatalog.lookup(definition);
        if (function == null) {
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.functionCatalog.lookup(DEFAULT_ROUTE_HANDLER);
        }
        return function;
    }
}

