/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.core.FluxSupplier;
import org.springframework.cloud.function.core.MonoSupplier;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageSupplier
implements Supplier<Publisher<Message<?>>> {
    private Supplier<?> delegate;

    public MessageSupplier(Supplier<?> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Publisher<Message<?>> get() {
        if (this.delegate instanceof FluxSupplier) {
            return ((Flux)this.delegate.get()).map(value -> MessageBuilder.withPayload((Object)value).build());
        }
        if (this.delegate instanceof MonoSupplier) {
            return ((Mono)this.delegate.get()).map(value -> MessageBuilder.withPayload((Object)value).build());
        }
        Object product = this.delegate.get();
        if (product instanceof Publisher) {
            return Flux.from((Publisher)((Publisher)product)).map(value -> MessageBuilder.withPayload((Object)value).build());
        }
        if (product instanceof Iterable) {
            return Flux.fromIterable((Iterable)((Iterable)product)).map(value -> MessageBuilder.withPayload((Object)value).build());
        }
        return Mono.just((Object)MessageBuilder.withPayload(product).build());
    }
}

