/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.json;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ResolvableType;

public abstract class JsonMapper {
    private static Log logger = LogFactory.getLog(JsonMapper.class);

    @Deprecated
    <T> List<T> toList(String json, Class<T> type) {
        Class<T> actualType = json.startsWith("[") && !List.class.isAssignableFrom(type) ? ResolvableType.forClassWithGenerics(ArrayList.class, (Class[])new Class[]{type}).getType() : type;
        return (List)this.toObject(json, actualType);
    }

    @Deprecated
    abstract <T> T toObject(String var1, Type var2);

    public abstract <T> T fromJson(Object var1, Type var2);

    public byte[] toJson(Object value) {
        byte[] result = null;
        if (JsonMapper.isJsonString(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"String already represents JSON. Skipping conversion in favor of 'getBytes(StandardCharsets.UTF_8'.");
            }
            result = ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        return result;
    }

    @Deprecated
    <T> T toSingle(String json, Class<T> type) {
        return this.toObject(json, type);
    }

    public abstract String toString(Object var1);

    public static boolean isJsonString(Object value) {
        boolean isJson = false;
        if (value instanceof byte[]) {
            value = new String((byte[])value, StandardCharsets.UTF_8);
        }
        if (value instanceof String) {
            String str = ((String)value).trim();
            isJson = str.startsWith("\"") && str.endsWith("\"") || str.startsWith("{") && str.endsWith("}") || str.startsWith("[") && str.endsWith("]");
        }
        return isJson;
    }
}

