/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.wiremock.restdocs;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.wiremock.restdocs.WireMockVerifyHelper;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.util.StringUtils;
import wiremock.com.google.common.base.Optional;
import wiremock.org.apache.commons.io.IOUtils;

public class ContractResultHandler
extends WireMockVerifyHelper<MvcResult, ContractResultHandler>
implements ResultHandler {
    static final String ATTRIBUTE_NAME_CONFIGURATION = "org.springframework.restdocs.configuration";

    public void handle(MvcResult result) throws Exception {
        this.configure(result);
    }

    @Override
    protected ResponseDefinitionBuilder getResponseDefinition(MvcResult result) {
        MockHttpServletResponse response = result.getResponse();
        try {
            ResponseDefinitionBuilder definition = ResponseDefinitionBuilder.responseDefinition().withBody(response.getContentAsString()).withStatus(response.getStatus());
            this.addResponseHeaders(definition, response);
            return definition;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Cannot create response body", e);
        }
    }

    private void addResponseHeaders(ResponseDefinitionBuilder definition, MockHttpServletResponse input) {
        for (String name : input.getHeaderNames()) {
            definition.withHeader(name, new String[]{input.getHeader(name)});
        }
    }

    @Override
    protected Map<String, Object> getConfiguration(MvcResult result) {
        HashMap map = (HashMap)result.getRequest().getAttribute(ATTRIBUTE_NAME_CONFIGURATION);
        if (map == null) {
            map = new HashMap();
            result.getRequest().setAttribute(ATTRIBUTE_NAME_CONFIGURATION, map);
        }
        return map;
    }

    @Override
    protected Request getWireMockRequest(final MvcResult result) {
        return new Request(){

            public String getUrl() {
                return result.getRequest().getRequestURI();
            }

            public String getAbsoluteUrl() {
                return result.getRequest().getRequestURI();
            }

            public RequestMethod getMethod() {
                return RequestMethod.fromString((String)result.getRequest().getMethod());
            }

            public String getScheme() {
                return result.getRequest().getScheme();
            }

            public String getHost() {
                return result.getRequest().getRemoteHost();
            }

            public int getPort() {
                return result.getRequest().getServerPort();
            }

            public String getClientIp() {
                return "";
            }

            public String getHeader(String key) {
                return result.getRequest().getHeader(key);
            }

            public HttpHeader header(String key) {
                return new HttpHeader(key, new String[]{this.getHeader(key)});
            }

            public ContentTypeHeader contentTypeHeader() {
                return new ContentTypeHeader(result.getRequest().getContentType());
            }

            public HttpHeaders getHeaders() {
                ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
                Enumeration headerNames = result.getRequest().getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String key = (String)headerNames.nextElement();
                    String value = this.getHeader(key);
                    headers.add(new HttpHeader(key, new String[]{value}));
                }
                return new HttpHeaders(headers);
            }

            public boolean containsHeader(String key) {
                Enumeration headerNames = result.getRequest().getHeaderNames();
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    if (!name.equals(key)) continue;
                    return true;
                }
                return false;
            }

            public Set<String> getAllHeaderKeys() {
                return this.getHeaders().keys();
            }

            public Map<String, com.github.tomakehurst.wiremock.http.Cookie> getCookies() {
                HashMap<String, com.github.tomakehurst.wiremock.http.Cookie> nameToCookie = new HashMap<String, com.github.tomakehurst.wiremock.http.Cookie>();
                if (result.getRequest().getCookies() == null) {
                    return nameToCookie;
                }
                for (Cookie cookie : result.getRequest().getCookies()) {
                    nameToCookie.put(cookie.getName(), new com.github.tomakehurst.wiremock.http.Cookie(cookie.getValue()));
                }
                return nameToCookie;
            }

            public QueryParameter queryParameter(String key) {
                return new QueryParameter(key, Collections.singletonList(result.getRequest().getParameter(key)));
            }

            public byte[] getBody() {
                return result.getRequest().getContentAsByteArray();
            }

            public String getBodyAsString() {
                try {
                    return result.getRequest().getContentAsString();
                }
                catch (Exception ex) {
                    return new String(result.getRequest().getContentAsByteArray());
                }
            }

            public String getBodyAsBase64() {
                return Base64.getEncoder().encodeToString(result.getRequest().getContentAsByteArray());
            }

            public boolean isMultipart() {
                return StringUtils.hasText((String)result.getRequest().getHeader("multipart/form-data"));
            }

            public Collection<Request.Part> getParts() {
                try {
                    return result.getRequest().getParts().stream().map(part -> new Request.Part(){
                        final /* synthetic */ Part val$part;
                        {
                            this.val$part = part;
                        }

                        public String getName() {
                            return this.val$part.getName();
                        }

                        public HttpHeader getHeader(String name) {
                            String header = this.val$part.getHeader(name);
                            return new HttpHeader(name, new String[]{header});
                        }

                        public HttpHeaders getHeaders() {
                            ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>();
                            for (String headerName : this.val$part.getHeaderNames()) {
                                headers.add(new HttpHeader(headerName, (Collection)this.getHeader(headerName).values()));
                            }
                            return new HttpHeaders(headers);
                        }

                        public Body getBody() {
                            try {
                                return new Body(IOUtils.toByteArray((InputStream)this.val$part.getInputStream()));
                            }
                            catch (IOException ex) {
                                throw new IllegalStateException(ex);
                            }
                        }
                    }).collect(Collectors.toList());
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }

            public Request.Part getPart(String name) {
                return this.getParts().stream().filter(part -> part.getName().equals(name)).findFirst().orElse(null);
            }

            public boolean isBrowserProxyRequest() {
                return false;
            }

            public Optional<Request> getOriginalRequest() {
                return Optional.absent();
            }

            public String getProtocol() {
                return result.getRequest().getProtocol();
            }
        };
    }

    @Override
    protected MediaType getContentType(MvcResult result) {
        return MediaType.valueOf((String)result.getRequest().getContentType());
    }

    @Override
    protected byte[] getRequestBodyContent(MvcResult result) {
        byte[] body = this.getWireMockRequest(result).getBody();
        return body != null ? body : new byte[]{};
    }
}

