/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.stream;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessaging;
import org.springframework.cloud.contract.verifier.messaging.noop.NoOpContractVerifierAutoConfiguration;
import org.springframework.cloud.contract.verifier.messaging.stream.ContractVerifierHelper;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamInputDestinationMessageSender;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamOutputDestinationMessageReceiver;
import org.springframework.cloud.contract.verifier.messaging.stream.StreamStubMessages;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.test.InputDestination;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Binder.class})
@ConditionalOnProperty(name={"spring.cloud.contract.stubrunner.stream.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={NoOpContractVerifierAutoConfiguration.class})
public class ContractVerifierStreamAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ContractVerifierMessaging.class})
    public ContractVerifierMessaging<?> streamContractVerifierMessaging(MessageVerifierSender<Message<?>> sender, MessageVerifierReceiver<Message<?>> receiver) {
        return new ContractVerifierHelper(sender, receiver);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={InputDestination.class})
    static class InputDestinationConfiguration {
        InputDestinationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={MessageVerifierSender.class})
        MessageVerifierSender<Message<?>> streamContractVerifierMessageSenderExchangeWithDestinations(ApplicationContext context) {
            final StreamStubMessages stubMessages = new StreamStubMessages(new StreamInputDestinationMessageSender(context), new StreamOutputDestinationMessageReceiver(context));
            return new MessageVerifierSender<Message<?>>(this){
                final /* synthetic */ InputDestinationConfiguration this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void send(Message<?> message, String destination, @Nullable YamlContract contract) {
                    stubMessages.send(message, destination, contract);
                }

                @Override
                public <T> void send(T payload, Map<String, Object> headers, String destination, @Nullable YamlContract contract) {
                    stubMessages.send(payload, headers, destination, contract);
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean(value={MessageVerifierReceiver.class})
        MessageVerifierReceiver<Message<?>> streamContractVerifierMessageReceiverExchangeWithDestinations(ApplicationContext context) {
            final StreamStubMessages stubMessages = new StreamStubMessages(new StreamInputDestinationMessageSender(context), new StreamOutputDestinationMessageReceiver(context));
            return new MessageVerifierReceiver<Message<?>>(this){
                final /* synthetic */ InputDestinationConfiguration this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Message<?> receive(String destination, long timeout, TimeUnit timeUnit, @Nullable YamlContract contract) {
                    return stubMessages.receive(destination, timeout, timeUnit, contract);
                }

                @Override
                public Message<?> receive(String destination, YamlContract contract) {
                    return stubMessages.receive(destination, contract);
                }
            };
        }
    }
}

