/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.verifier.builder.Acceptor;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.Field;
import org.springframework.cloud.contract.verifier.builder.FieldBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.SingleMethodBuilder;
import org.springframework.cloud.contract.verifier.builder.Visitor;

class ClassBodyBuilder {
    private List<Field> fields = new LinkedList<Field>();
    private SingleMethodBuilder methodBuilder;
    final BlockBuilder blockBuilder;
    final GeneratedClassMetaData generatedClassMetaData;

    private ClassBodyBuilder(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    static ClassBodyBuilder builder(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        return new ClassBodyBuilder(blockBuilder, generatedClassMetaData);
    }

    FieldBuilder field() {
        return new FieldBuilder(this);
    }

    ClassBodyBuilder field(Field field) {
        this.fields.add(field);
        return this;
    }

    ClassBodyBuilder methodBuilder(SingleMethodBuilder methodBuilder) {
        this.methodBuilder = methodBuilder;
        return this;
    }

    BlockBuilder build() {
        this.blockBuilder.inBraces(() -> {
            this.visit(this.fields);
            this.methodBuilder.build();
        });
        return this.blockBuilder;
    }

    void visit(List<? extends Visitor> list) {
        List visitors = list.stream().filter(Acceptor::accept).collect(Collectors.toList());
        Iterator iterator = visitors.iterator();
        while (iterator.hasNext()) {
            Visitor visitor = (Visitor)iterator.next();
            visitor.call();
            this.blockBuilder.addEndingIfNotPresent();
            if (!iterator.hasNext()) continue;
            this.blockBuilder.addEmptyLine();
        }
    }
}

