/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyReader;
import org.springframework.cloud.contract.verifier.builder.CommunicationType;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.EscapedString;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class BodyAssertionLineCreator {
    private final BlockBuilder blockBuilder;
    private final BodyReader bodyReader;
    private final String byteArrayString;
    private final ComparisonBuilder comparisonBuilder;

    BodyAssertionLineCreator(BlockBuilder blockBuilder, GeneratedClassMetaData metaData, String byteArrayString, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.bodyReader = new BodyReader(metaData);
        this.byteArrayString = byteArrayString;
        this.comparisonBuilder = comparisonBuilder;
    }

    void appendBodyAssertionLine(SingleContractMetadata metadata, String property, Object value) {
        if (value instanceof String && ((String)value).startsWith("$")) {
            String newValue = this.stripFirstChar((String)value).replaceAll("\\$value", "responseBody" + property);
            this.blockBuilder.addLineWithEnding(newValue);
        } else {
            this.blockBuilder.addLineWithEnding(this.getResponseBodyPropertyComparisonString(metadata, property, value));
        }
    }

    private String getResponseBodyPropertyComparisonString(SingleContractMetadata singleContractMetadata, String property, Object value) {
        if (value instanceof FromFileProperty) {
            return this.getResponseBodyPropertyComparisonString(singleContractMetadata, property, (FromFileProperty)value);
        }
        if (value instanceof Pattern) {
            return this.getResponseBodyPropertyComparisonString(property, (Pattern)value);
        }
        if (value instanceof ExecutionProperty) {
            return this.getResponseBodyPropertyComparisonString(property, (ExecutionProperty)value);
        }
        if (value instanceof DslProperty) {
            return this.getResponseBodyPropertyComparisonString(singleContractMetadata, property, ((DslProperty)value).getServerValue());
        }
        if (value instanceof EscapedString) {
            return this.getResponseBodyPropertyComparisonString(property, (EscapedString)value);
        }
        return this.getResponseBodyPropertyComparisonString(property, value.toString());
    }

    private String getResponseBodyPropertyComparisonString(SingleContractMetadata singleContractMetadata, String property, FromFileProperty value) {
        if (value.isByte()) {
            return this.comparisonBuilder.assertThat(this.byteArrayString) + this.comparisonBuilder.isEqualToUnquoted(this.bodyReader.readBytesFromFileString(singleContractMetadata, value, CommunicationType.RESPONSE));
        }
        return this.getResponseBodyPropertyComparisonString(property, value.asString());
    }

    private String getResponseBodyPropertyComparisonString(String property, String value) {
        return this.comparisonBuilder.assertThatUnescaped("responseBody" + property, value);
    }

    private String getResponseBodyPropertyComparisonString(String property, EscapedString value) {
        String quoted = this.comparisonBuilder.bodyParser().quotedEscapedShortText(value.value());
        return this.comparisonBuilder.assertThat("responseBody" + property) + this.comparisonBuilder.isEqualToUnquoted(quoted);
    }

    private String getResponseBodyPropertyComparisonString(String property, Pattern value) {
        return this.comparisonBuilder.assertThat("responseBody" + property, value);
    }

    private String getResponseBodyPropertyComparisonString(String property, ExecutionProperty value) {
        return value.insertValue("responseBody" + property);
    }

    private String stripFirstChar(String s) {
        return s.substring(1);
    }
}

