/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.cloud.contract.verifier.util.CantInstantiateThisClass;
import org.springframework.util.ReflectionUtils;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.PropertyWriter;
import tools.jackson.databind.ser.std.SimpleBeanPropertyFilter;

class MyFilter
extends SimpleBeanPropertyFilter
implements Serializable {
    private static final Map<Class, Object> CACHE = new ConcurrentHashMap<Class, Object>();

    MyFilter() {
    }

    public void serializeAsProperty(Object pojo, JsonGenerator jgen, SerializationContext provider, PropertyWriter writer) throws Exception {
        if (pojo instanceof Map || pojo instanceof Collection) {
            writer.serializeAsProperty(pojo, jgen, provider);
            return;
        }
        Object defaultInstance = this.defaultInstance(pojo);
        if (defaultInstance instanceof CantInstantiateThisClass || !this.valueSameAsDefault(pojo, defaultInstance, writer.getName())) {
            writer.serializeAsProperty(pojo, jgen, provider);
        }
    }

    Object defaultInstance(Object pojo) {
        return CACHE.computeIfAbsent(pojo.getClass(), this::defaultInstance);
    }

    private Object defaultInstance(Class aClass) {
        try {
            return aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return new CantInstantiateThisClass();
        }
    }

    boolean valueSameAsDefault(Object pojo, Object defaultInstance, String fieldName) {
        Field field = ReflectionUtils.findField(pojo.getClass(), (String)fieldName);
        if (field == null) {
            return false;
        }
        ReflectionUtils.makeAccessible((Field)field);
        try {
            return Objects.equals(field.get(pojo), field.get(defaultInstance));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

