/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.integration;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierReceiver;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifierSender;
import org.springframework.cloud.contract.verifier.messaging.integration.ContractVerifierIntegrationMessageBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;

public class SpringIntegrationStubMessages
implements MessageVerifierSender<Message<?>>,
MessageVerifierReceiver<Message<?>> {
    private static final Log log = LogFactory.getLog(SpringIntegrationStubMessages.class);
    private final ApplicationContext context;
    private final ContractVerifierIntegrationMessageBuilder builder = new ContractVerifierIntegrationMessageBuilder();

    public SpringIntegrationStubMessages(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public <T> void send(T payload, Map<String, Object> headers, String destination, YamlContract contract) {
        this.send(this.builder.create(payload, headers), destination, contract);
    }

    @Override
    public void send(Message<?> message, String destination, YamlContract contract) {
        try {
            MessageChannel messageChannel = (MessageChannel)this.context.getBean(destination, MessageChannel.class);
            messageChannel.send(message);
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to send a message [" + String.valueOf(message) + "] to a channel with name [" + destination + "]"), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Message<?> receive(String destination, long timeout, TimeUnit timeUnit, YamlContract contract) {
        try {
            PollableChannel messageChannel = (PollableChannel)this.context.getBean(destination, PollableChannel.class);
            return messageChannel.receive(timeUnit.toMillis(timeout));
        }
        catch (Exception e) {
            log.error((Object)("Exception occurred while trying to read a message from  a channel with name [" + destination + "]"), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Message<?> receive(String destination, YamlContract contract) {
        return this.receive(destination, 5L, TimeUnit.SECONDS, contract);
    }
}

