/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.Request;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.Given;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.http.ContractVerifierHttpMetaData;

class CustomModeSchemeProtocolGiven
implements Given {
    private final BlockBuilder blockBuilder;

    CustomModeSchemeProtocolGiven(BlockBuilder blockBuilder) {
        this.blockBuilder = blockBuilder;
    }

    @Override
    public MethodVisitor<Given> apply(SingleContractMetadata metadata) {
        Contract contract = metadata.getContract();
        ContractVerifierHttpMetaData httpMetadata = ContractVerifierHttpMetaData.fromMetadata(contract.getMetadata());
        this.blockBuilder.addIndented(".scheme(\"" + httpMetadata.getScheme().name() + "\")").addEmptyLine();
        this.blockBuilder.addIndented(".protocol(\"" + httpMetadata.getProtocol().toString() + "\")");
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Request request = metadata.getContract().getRequest();
        return request != null;
    }
}

