/*
 * Copyright 2013-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.contract.verifier.config.framework;

/**
 * Defines elements characteristic of TestNG test framework to be used during test class
 * construction.
 *
 * @author André Hoffmann
 * @since 2.2.0
 */
public class TestNGDefinition implements TestFrameworkDefinition {

	@Override
	public String getClassExtension() {
		return ".java";
	}

	@Override
	public String getClassNameSuffix() {
		return "Test";
	}

	@Override
	public String getIgnoreClass() {
		throw new UnsupportedOperationException(
				"There is no @Ignore annotation for TestNG. A test can be disabled directly in the @Test annotation");
	}

	@Override
	public String getIgnoreAnnotation() {
		throw new UnsupportedOperationException(
				"There is no @Ignore annotation for TestNG. A test can be disabled directly in the @Test annotation");
	}

}
