/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyAssertionLineCreator;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.ComparisonBuilder;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;

class GenericBinaryBodyThen
implements Then {
    private final BlockBuilder blockBuilder;
    private final BodyAssertionLineCreator bodyAssertionLineCreator;
    private final BodyParser bodyParser;
    private final ComparisonBuilder comparisonBuilder;

    GenericBinaryBodyThen(BlockBuilder blockBuilder, GeneratedClassMetaData metaData, BodyParser bodyParser, ComparisonBuilder comparisonBuilder) {
        this.blockBuilder = blockBuilder;
        this.comparisonBuilder = comparisonBuilder;
        this.bodyAssertionLineCreator = new BodyAssertionLineCreator(blockBuilder, metaData, bodyParser.byteArrayString(), this.comparisonBuilder);
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        Object responseBody = this.bodyParser.responseBody(metadata).getServerValue();
        this.byteResponseBodyCheck(metadata, (FromFileProperty)responseBody);
        return this;
    }

    private void byteResponseBodyCheck(SingleContractMetadata metadata, FromFileProperty convertedResponseBody) {
        this.bodyAssertionLineCreator.appendBodyAssertionLine(metadata, "", convertedResponseBody);
        this.blockBuilder.addEndingIfNotPresent();
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        Object responseBody = this.bodyParser.responseBody(metadata).getServerValue();
        if (!(responseBody instanceof FromFileProperty)) {
            return false;
        }
        return ((FromFileProperty)responseBody).isByte();
    }
}

