/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.messaging.amqp;

import com.rabbitmq.client.Channel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.cloud.contract.verifier.converter.YamlContract;
import org.springframework.cloud.contract.verifier.messaging.MessageVerifier;
import org.springframework.cloud.contract.verifier.messaging.amqp.AmqpMetadata;
import org.springframework.cloud.contract.verifier.messaging.amqp.MessageListenerAccessor;
import org.springframework.cloud.contract.verifier.messaging.internal.ContractVerifierMessageMetadata;
import org.springframework.cloud.contract.verifier.util.MetadataUtil;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;

public class SpringAmqpStubMessages
implements MessageVerifier<Message> {
    private static final Log log = LogFactory.getLog(SpringAmqpStubMessages.class);
    private final RabbitTemplate rabbitTemplate;
    private final MessageListenerAccessor messageListenerAccessor;
    private RabbitProperties rabbitProperties;

    @Autowired
    public SpringAmqpStubMessages(RabbitTemplate rabbitTemplate, MessageListenerAccessor messageListenerAccessor, RabbitProperties rabbitProperties) {
        Assert.notNull((Object)rabbitTemplate, (String)"RabbitTemplate must be set");
        Assert.isTrue((Mockito.mockingDetails((Object)rabbitTemplate).isSpy() || Mockito.mockingDetails((Object)rabbitTemplate).isMock() ? 1 : 0) != 0, (String)"StubRunner AMQP will work only if RabbiTemplate is a spy");
        this.rabbitTemplate = rabbitTemplate;
        this.messageListenerAccessor = messageListenerAccessor;
        this.rabbitProperties = rabbitProperties;
    }

    @Override
    public <T> void send(T payload, Map<String, Object> messageHeaders, String destination, YamlContract contract) {
        MessageHeaders headers = new MessageHeaders(messageHeaders);
        Message message = MessageBuilder.withBody((byte[])((String)payload).getBytes()).andProperties((MessageProperties)MessagePropertiesBuilder.newInstance().setContentType(this.header(headers, "contentType")).copyHeaders((Map)headers).build()).build();
        if (headers.containsKey((Object)"__TypeId__")) {
            message.getMessageProperties().setHeader("__TypeId__", headers.get((Object)"__TypeId__"));
        }
        if (headers.containsKey((Object)"amqp_receivedRoutingKey")) {
            message.getMessageProperties().setReceivedRoutingKey(this.header(headers, "amqp_receivedRoutingKey"));
        }
        this.send(message, destination, contract);
    }

    private String header(MessageHeaders headers, String headerName) {
        Object value = headers.get((Object)headerName);
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Iterable) {
            Iterable values = (Iterable)value;
            return values.iterator().hasNext() ? (String)values.iterator().next() : "";
        }
        return value.toString();
    }

    public void mergeMessagePropertiesFromMetadata(YamlContract contract, Message message) {
        if (contract != null && contract.metadata.containsKey("amqp")) {
            AmqpMetadata amqpMetadata = AmqpMetadata.fromMetadata(contract.metadata);
            ContractVerifierMessageMetadata messageMetadata = ContractVerifierMessageMetadata.fromMetadata(contract.metadata);
            boolean isInput = this.isInputMessage(messageMetadata);
            MessageProperties fromMetadata = isInput ? amqpMetadata.getInput().getMessageProperties() : amqpMetadata.getOutputMessage().getMessageProperties();
            MetadataUtil.merge(message.getMessageProperties(), fromMetadata);
        }
    }

    public boolean isInputMessage(ContractVerifierMessageMetadata messageMetadata) {
        return messageMetadata.getMessageType() == ContractVerifierMessageMetadata.MessageType.INPUT;
    }

    @Override
    public void send(Message message, String destination, YamlContract contract) {
        this.mergeMessagePropertiesFromMetadata(contract, message);
        String routingKey = message.getMessageProperties().getReceivedRoutingKey();
        List<SimpleMessageListenerContainer> listenerContainers = this.messageListenerAccessor.getListenerContainersForDestination(destination, routingKey);
        if (listenerContainers.isEmpty()) {
            throw new IllegalStateException("no listeners found for destination " + destination);
        }
        for (SimpleMessageListenerContainer listenerContainer : listenerContainers) {
            Object messageListener;
            if (this.isChannelAwareListener(listenerContainer, messageListener = listenerContainer.getMessageListener())) {
                try {
                    ((ChannelAwareMessageListener)messageListener).onMessage(message, this.createChannel(listenerContainer, this.transactionalChannel()));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ((MessageListener)messageListener).onMessage(message);
        }
    }

    Channel createChannel(SimpleMessageListenerContainer listenerContainer, boolean transactional) {
        return listenerContainer.getConnectionFactory().createConnection().createChannel(transactional);
    }

    boolean isChannelAwareListener(SimpleMessageListenerContainer listenerContainer, Object messageListener) {
        return messageListener instanceof ChannelAwareMessageListener && listenerContainer.getConnectionFactory() != null;
    }

    private boolean transactionalChannel() {
        if (this.rabbitProperties == null) {
            return true;
        }
        return this.rabbitProperties.getPublisherConfirmType() == null || this.rabbitProperties.getPublisherConfirmType() == CachingConnectionFactory.ConfirmType.NONE;
    }

    @Override
    public Message receive(String destination, long timeout, TimeUnit timeUnit, YamlContract contract) {
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ArgumentCaptor routingKeyCaptor = ArgumentCaptor.forClass(String.class);
        ((RabbitTemplate)Mockito.verify((Object)this.rabbitTemplate, (VerificationMode)Mockito.atLeastOnce())).send((String)Matchers.eq((Object)destination), (String)routingKeyCaptor.capture(), (Message)messageCaptor.capture(), (CorrelationData)ArgumentMatchers.any());
        if (messageCaptor.getAllValues().isEmpty()) {
            log.info((Object)("no messages found on destination [" + destination + "]"));
            return null;
        }
        if (messageCaptor.getAllValues().size() > 1) {
            log.info((Object)("multiple messages found on destination [" + destination + "] returning last one"));
            return (Message)messageCaptor.getValue();
        }
        Message message = (Message)messageCaptor.getValue();
        if (message == null) {
            log.info((Object)("no messages found on destination [" + destination + "]"));
            return null;
        }
        if (!((String)routingKeyCaptor.getValue()).isEmpty()) {
            log.info((Object)("routing key passed [" + (String)routingKeyCaptor.getValue() + "]"));
            message.getMessageProperties().setReceivedRoutingKey((String)routingKeyCaptor.getValue());
        }
        return message;
    }

    @Override
    public Message receive(String destination, YamlContract contract) {
        return this.receive(destination, 5L, TimeUnit.SECONDS, contract);
    }
}

