/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.io.File;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.util.StringUtils;

class NameProvider {
    private static final Log log = LogFactory.getLog(NameProvider.class);

    NameProvider() {
    }

    String methodName(SingleContractMetadata singleContractMetadata) {
        return "validate_" + this.generateMethodName(singleContractMetadata);
    }

    private String generateMethodName(SingleContractMetadata singleContractMetadata) {
        ContractMetadata contractMetadata = singleContractMetadata.getContractMetadata();
        File stubsFile = contractMetadata.getPath().toFile();
        Contract stubContent = singleContractMetadata.getContract();
        if (StringUtils.hasText((String)stubContent.getName())) {
            String name = NamesUtil.camelCase(NamesUtil.convertIllegalPackageChars(stubContent.getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Overriding the default test name with [" + name + "]"));
            }
            return name;
        }
        if (contractMetadata.getConvertedContract().size() > 1) {
            int index = this.findIndexOf(contractMetadata.getConvertedContract(), stubContent);
            String name = this.camelCasedMethodFromFileName(stubsFile) + "_" + index;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scenario found. The method name will be [" + name + "]"));
            }
            return name;
        }
        String name = this.camelCasedMethodFromFileName(stubsFile);
        if (StringUtils.hasText((String)name) && log.isDebugEnabled()) {
            log.debug((Object)("The method name will be [" + name + "]"));
        }
        return name;
    }

    private int findIndexOf(Collection<Contract> contracts, Contract stubContent) {
        int i = 0;
        for (Contract contract : contracts) {
            if (contract.equals((Object)stubContent)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String camelCasedMethodFromFileName(File stubsFile) {
        return NamesUtil.camelCase(NamesUtil.convertIllegalMethodNameChars(NamesUtil.toLastDot(NamesUtil.afterLast(stubsFile.getPath(), File.separator))));
    }
}

