/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Optional;
import org.springframework.cloud.contract.spec.internal.BodyMatchers;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.BodyParser;
import org.springframework.cloud.contract.verifier.builder.MethodVisitor;
import org.springframework.cloud.contract.verifier.builder.Then;
import org.springframework.cloud.contract.verifier.builder.XmlBodyVerificationBuilder;
import org.springframework.cloud.contract.verifier.file.SingleContractMetadata;
import org.springframework.cloud.contract.verifier.util.ContentType;

class GenericXmlBodyThen
implements Then {
    private final BlockBuilder blockBuilder;
    private final BodyParser bodyParser;

    GenericXmlBodyThen(BlockBuilder blockBuilder, BodyParser bodyParser) {
        this.blockBuilder = blockBuilder;
        this.bodyParser = bodyParser;
    }

    @Override
    public MethodVisitor<Then> apply(SingleContractMetadata metadata) {
        BodyMatchers bodyMatchers = this.bodyParser.responseBodyMatchers(metadata);
        Object convertedResponseBody = this.bodyParser.convertResponseBody(metadata);
        XmlBodyVerificationBuilder xmlBodyVerificationBuilder = new XmlBodyVerificationBuilder(metadata.getContract(), Optional.of(this.blockBuilder.getLineEnding()));
        xmlBodyVerificationBuilder.addXmlResponseBodyCheck(this.blockBuilder, convertedResponseBody, bodyMatchers, this.bodyParser.responseAsString(), true);
        return this;
    }

    @Override
    public boolean accept(SingleContractMetadata metadata) {
        ContentType outputTestContentType = metadata.getOutputTestContentType();
        return ContentType.XML == outputTestContentType;
    }
}

