/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.converter.StubGenerator;
import org.springframework.cloud.contract.verifier.converter.StubGeneratorProvider;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.wiremock.DslToWireMockClientConverter;
import org.springframework.util.StringUtils;

final class MappingGenerator {
    private static final Log log = LogFactory.getLog(MappingGenerator.class);

    private MappingGenerator() {
        throw new IllegalStateException("Can't instantiate utility class");
    }

    static Collection<Path> toMappings(File contractFile, Collection<Contract> contracts, File mappingsFolder) {
        StubGeneratorProvider provider = new StubGeneratorProvider();
        Collection stubGenerators = provider.allOrDefault((StubGenerator)new DslToWireMockClientConverter());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found following matching stub generators " + String.valueOf(stubGenerators)));
        }
        LinkedList<Path> mappings = new LinkedList<Path>();
        for (StubGenerator stubGenerator : stubGenerators) {
            Map map = stubGenerator.convertContents(contractFile.getName(), new ContractMetadata(contractFile.toPath(), false, contracts.size(), null, contracts));
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                File mapping = new File(mappingsFolder, StringUtils.stripFilenameExtension((String)contractFile.getName()) + "_" + Math.abs(((Contract)entry.getKey()).hashCode()) + stubGenerator.fileExtension());
                mappings.add(MappingGenerator.storeFile(mapping.toPath(), value.getBytes()));
            }
        }
        return mappings;
    }

    private static Path storeFile(Path path, byte[] contents) {
        try {
            Path storedPath = Files.write(path, contents, new OpenOption[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stored file [" + path.toString() + "]"));
            }
            return storedPath;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

