/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

final class AetherFactories {
    private static final Log log = LogFactory.getLog(AetherFactories.class);
    private static final String MAVEN_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";
    private static final String MAVEN_USER_SETTINGS_LOCATION = "org.apache.maven.user-settings";
    private static final String MAVEN_GLOBAL_SETTINGS_LOCATION = "org.apache.maven.global-settings";
    private static final Random RANDOM = new Random();

    private AetherFactories() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static RepositorySystem repositorySystemOr(@Nullable RepositorySystem injectedOrNull) {
        if (injectedOrNull != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using Maven-injected RepositorySystem");
            }
            return injectedOrNull;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No injected RepositorySystem provided; creating one via ServiceLocator");
        }
        return AetherFactories.newRepositorySystemFallback();
    }

    static RepositorySystemSession sessionOr(RepositorySystem system, @Nullable RepositorySystemSession injectedOrNull, boolean workOffline) {
        if (injectedOrNull != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using Maven-injected RepositorySystemSession (workOffline=" + injectedOrNull.isOffline() + ")"));
            }
            return injectedOrNull;
        }
        return AetherFactories.newSession(system, workOffline);
    }

    private static RepositorySystem newRepositorySystemFallback() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to create service " + type.getName() + " via " + (impl != null ? impl.getName() : "<null>") + ": " + exception.toString()));
                }
            }
        });
        AetherFactories.registerIfPresent(locator, "org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory", RepositoryConnectorFactory.class);
        AetherFactories.registerIfPresent(locator, "org.eclipse.aether.transport.file.FileTransporterFactory", TransporterFactory.class);
        AetherFactories.registerIfPresent(locator, "org.eclipse.aether.transport.http.HttpTransporterFanewRepositorySystemctory", TransporterFactory.class);
        RepositorySystem system = (RepositorySystem)locator.getService(RepositorySystem.class);
        if (system == null) {
            throw new IllegalStateException("Failed to obtain RepositorySystem. Ensure Maven Resolver is on the classpath and, when running inside a Maven plugin, prefer using the Maven-injected RepositorySystem/RepositorySystemSession.");
        }
        return system;
    }

    private static void registerIfPresent(DefaultServiceLocator locator, String implClassName, Class<?> serviceType) {
        block6: {
            try {
                Class<?> impl;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = AetherFactories.class.getClassLoader();
                }
                if (!serviceType.isAssignableFrom(impl = Class.forName(implClassName, false, cl))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Class " + implClassName + " is not assignable to " + serviceType.getName()));
                    }
                    return;
                }
                locator.addService(serviceType, impl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registered " + implClassName + " as " + serviceType.getSimpleName()));
                }
            }
            catch (ClassNotFoundException ex) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("Optional provider not found on classpath: " + implClassName));
            }
        }
    }

    static RepositorySystemSession newSession(RepositorySystem system, boolean workOffline) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setOffline(workOffline);
        if (!workOffline) {
            session.setUpdatePolicy("always");
        }
        session.setChecksumPolicy("warn");
        String localRepositoryDirectory = AetherFactories.localRepositoryDirectory(workOffline);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Local Repository Directory set to [" + localRepositoryDirectory + "]. Work offline: [" + workOffline + "]"));
        }
        LocalRepository localRepo = new LocalRepository(localRepositoryDirectory);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        return session;
    }

    static String localRepositoryDirectory(boolean workOffline) {
        String localRepoLocationFromSettings = AetherFactories.settings().getLocalRepository();
        String currentLocalRepo = AetherFactories.readPropertyFromSystemProps(localRepoLocationFromSettings);
        if (workOffline) {
            return currentLocalRepo;
        }
        return AetherFactories.temporaryDirectory();
    }

    private static String temporaryDirectory() {
        try {
            return Files.createTempDirectory("aether-local", new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to create a new temporary directory, will generate a new one under temp dir", (Throwable)e);
            }
            return System.getProperty("java.io.tmpdir") + File.separator + RANDOM.nextInt();
        }
    }

    private static String readPropertyFromSystemProps(@Nullable String localRepoLocationFromSettings) {
        String mavenLocalRepo = AetherFactories.fromSystemPropOrEnv(MAVEN_LOCAL_REPOSITORY_LOCATION);
        return StringUtils.hasText((String)mavenLocalRepo) ? mavenLocalRepo : (localRepoLocationFromSettings != null ? localRepoLocationFromSettings : System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository");
    }

    private static String fromSystemPropOrEnv(String prop) {
        String resolvedProp = System.getProperty(prop);
        if (StringUtils.hasText((String)resolvedProp)) {
            return resolvedProp;
        }
        return System.getenv(prop);
    }

    private static File userSettings() {
        String user = AetherFactories.fromSystemPropOrEnv(MAVEN_USER_SETTINGS_LOCATION);
        if (user == null) {
            File file = new File(new File(System.getProperty("user.home")).getAbsoluteFile(), File.separator + ".m2" + File.separator + "settings.xml");
            if (log.isDebugEnabled()) {
                log.debug((Object)("No custom maven user settings provided, will use [" + String.valueOf(file) + "]"));
            }
            return file;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Custom location provided for user settings [" + user + "]"));
        }
        return new File(user);
    }

    static Settings settings() {
        DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(AetherFactories.userSettings());
        String global = AetherFactories.fromSystemPropOrEnv(MAVEN_GLOBAL_SETTINGS_LOCATION);
        if (global != null) {
            request.setGlobalSettingsFile(new File(global));
        }
        try {
            SettingsBuildingResult result = builder.build((SettingsBuildingRequest)request);
            return result.getEffectiveSettings();
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

