/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.springframework.util.StreamUtils;

public final class ZipCategory {
    private ZipCategory() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static Collection<File> unzipTo(File self, File destination) {
        ZipCategory.checkUnzipDestination(destination);
        if (destination == null) {
            destination = new File(self.getParent());
        }
        ArrayList<File> unzippedFiles = new ArrayList<File>();
        try (InputStream fileInputStream = Files.newInputStream(self.toPath(), new OpenOption[0]);
             ZipInputStream zipInput = new ZipInputStream(fileInputStream);){
            ZipEntry entry = zipInput.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    File destinationFile = new File(destination, entry.getName());
                    String zipEntryName = entry.getName();
                    if (!destinationFile.toPath().normalize().startsWith(destination.toPath())) {
                        throw new ZipException("The file " + zipEntryName + " is trying to leave the target output directory of " + destination);
                    }
                    if (destinationFile.getParentFile() != null) {
                        destinationFile.getParentFile().mkdirs();
                    }
                    try (OutputStream output = Files.newOutputStream(destinationFile.toPath(), new OpenOption[0]);){
                        StreamUtils.copy((InputStream)zipInput, (OutputStream)output);
                    }
                    unzippedFiles.add(destinationFile);
                } else {
                    File dir = new File(destination, entry.getName());
                    dir.mkdirs();
                    unzippedFiles.add(dir);
                }
                entry = zipInput.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot unzip archive", e);
        }
        return unzippedFiles;
    }

    private static void checkUnzipDestination(File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("'destination' has to be a directory.");
        }
    }
}

