/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.contract.stubrunner.StubFinder;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerDiscoveryClient;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubRunnerNoOpReactiveDiscoveryClient;
import reactor.core.publisher.Flux;

class StubRunnerReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Log log = LogFactory.getLog(StubRunnerReactiveDiscoveryClient.class);
    private final ReactiveDiscoveryClient delegate;
    private final StubFinder stubFinder;
    private final StubMapperProperties stubMapperProperties;

    StubRunnerReactiveDiscoveryClient(ReactiveDiscoveryClient delegate, StubFinder stubFinder, StubMapperProperties stubMapperProperties) {
        ReactiveDiscoveryClient reactiveDiscoveryClient = this.delegate = delegate instanceof StubRunnerDiscoveryClient ? this.noOpDiscoveryClient() : delegate;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will delegate calls to discovery service [" + this.delegate + "] if a stub is not found"));
        }
        this.stubFinder = stubFinder;
        this.stubMapperProperties = stubMapperProperties;
    }

    StubRunnerReactiveDiscoveryClient(StubFinder stubFinder, StubMapperProperties stubMapperProperties) {
        this.delegate = this.noOpDiscoveryClient();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will delegate calls to discovery service [" + this.delegate + "] if a stub is not found"));
        }
        this.stubFinder = stubFinder;
        this.stubMapperProperties = stubMapperProperties;
    }

    private StubRunnerNoOpReactiveDiscoveryClient noOpDiscoveryClient() {
        return new StubRunnerNoOpReactiveDiscoveryClient();
    }

    public String description() {
        try {
            return this.delegate.description();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to fetch description from delegate", (Throwable)e);
            }
            return "";
        }
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Flux.just((Object)this.client()).flatMapIterable(c -> c.getInstances(serviceId));
    }

    private StubRunnerDiscoveryClient client() {
        return new StubRunnerDiscoveryClient(this.stubFinder, this.stubMapperProperties);
    }

    public Flux<String> getServices() {
        return Flux.just((Object)this.client()).flatMapIterable(StubRunnerDiscoveryClient::getServices);
    }

    public int getOrder() {
        return this.delegate.getOrder();
    }
}

