/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import org.springframework.cloud.contract.spec.ContractTemplate;

public class HandlebarsContractTemplate
implements ContractTemplate {
    @Override
    public String openingTemplate() {
        return "{{";
    }

    @Override
    public String closingTemplate() {
        return "}}";
    }

    @Override
    public String escapedOpeningTemplate() {
        return "{{{";
    }

    @Override
    public String escapedClosingTemplate() {
        return "}}}";
    }

    @Override
    public String url() {
        return this.wrapped("request.url");
    }

    @Override
    public String query(String key) {
        return this.query(key, 0);
    }

    @Override
    public String query(String key, int index) {
        return this.wrapped("request.query." + key + ".[" + index + "]");
    }

    @Override
    public String path() {
        return this.wrapped("request.path");
    }

    @Override
    public String path(int index) {
        return this.wrapped("request.path.[" + index + "]");
    }

    @Override
    public String header(String key) {
        return this.header(key, 0);
    }

    @Override
    public String header(String key, int index) {
        return this.wrapped("request.headers." + key + ".[" + index + "]");
    }

    @Override
    public String cookie(String key) {
        return this.wrapped("request.cookies." + key);
    }

    @Override
    public String body() {
        return this.wrapped("request.body");
    }

    @Override
    public String escapedBody() {
        return this.escapedWrapped("escapejsonbody");
    }

    @Override
    public String escapedBody(String jsonPath) {
        return this.escapedWrapped("jsonPath request.body '" + jsonPath + "'");
    }

    @Override
    public String body(String jsonPath) {
        return this.wrapped("jsonPath request.body '" + jsonPath + "'");
    }

    @Override
    public String escapedUrl() {
        return this.escapedWrapped("request.url");
    }

    @Override
    public String escapedQuery(String key) {
        return this.escapedQuery(key, 0);
    }

    @Override
    public String escapedQuery(String key, int index) {
        return this.escapedWrapped("request.query." + key + ".[" + index + "]");
    }

    @Override
    public String escapedPath() {
        return this.escapedWrapped("request.path");
    }

    @Override
    public String escapedPath(int index) {
        return this.escapedWrapped("request.path.[" + index + "]");
    }

    @Override
    public String escapedHeader(String key) {
        return this.escapedHeader(key, 0);
    }

    @Override
    public String escapedHeader(String key, int index) {
        return this.escapedWrapped("request.headers." + key + ".[" + index + "]");
    }

    @Override
    public String escapedCookie(String key) {
        return this.escapedWrapped("request.cookies." + key);
    }

    private String wrapped(String text) {
        return this.openingTemplate() + text + this.closingTemplate();
    }

    private String escapedWrapped(String text) {
        return this.escapedOpeningTemplate() + text + this.escapedClosingTemplate();
    }
}

