/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.internal.ContractUtils;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;

public class Multipart
extends DslProperty {
    public Multipart(Map<String, DslProperty> multipart) {
        super(Multipart.extractValue(multipart, ContractUtils.CLIENT_VALUE), Multipart.extractValue(multipart, ContractUtils.SERVER_VALUE));
    }

    public Multipart(List<DslProperty> multipartAsList) {
        super(multipartAsList.stream().map(DslProperty::getClientValue).collect(Collectors.toList()), multipartAsList.stream().map(DslProperty::getServerValue).collect(Collectors.toList()));
    }

    public Multipart(Object value) {
        super(ContractUtils.CLIENT_VALUE.apply(value), ContractUtils.SERVER_VALUE.apply(value));
    }

    public Multipart(DslProperty multipartAsValue) {
        super(multipartAsValue.getClientValue(), multipartAsValue.getServerValue());
    }

    public Multipart(MatchingStrategy matchingStrategy) {
        super(matchingStrategy);
    }

    public static Multipart build(Object value) {
        if (value instanceof MatchingStrategy) {
            return new Multipart((MatchingStrategy)value);
        }
        return new Multipart(value);
    }

    private static Map<String, Object> extractValue(Map<String, DslProperty> multipart, Function valueProvider) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        multipart.forEach((s, dslProperty) -> map.put((String)s, valueProvider.apply(dslProperty)));
        return map;
    }
}

