/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.springframework.cloud.contract.spec.internal.BodyMatcher;
import org.springframework.cloud.contract.spec.internal.MatchingType;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.MatchingTypeValueHolder;
import org.springframework.cloud.contract.spec.internal.PathBodyMatcher;
import org.springframework.cloud.contract.spec.internal.RegexMatchingTypeValue;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.RegexProperty;

public class BodyMatchers {
    protected final List<BodyMatcher> matchers = new LinkedList<BodyMatcher>();

    public void jsonPath(String path, MatchingTypeValue matchingType) {
        this.matchers.add(new PathBodyMatcher(path, matchingType));
    }

    public void xPath(String xPath, MatchingTypeValue matchingTypeValue) {
        this.matchers.add(new PathBodyMatcher(xPath, matchingTypeValue));
    }

    public boolean hasMatchers() {
        return !this.matchers.isEmpty();
    }

    public List<BodyMatcher> matchers() {
        return this.matchers;
    }

    public MatchingTypeValue byDate() {
        return new MatchingTypeValue(MatchingType.DATE, RegexPatterns.isoDate());
    }

    public MatchingTypeValue byTime() {
        return new MatchingTypeValue(MatchingType.TIME, RegexPatterns.isoTime());
    }

    public MatchingTypeValue byTimestamp() {
        return new MatchingTypeValue(MatchingType.TIMESTAMP, RegexPatterns.isoDateTime());
    }

    public RegexMatchingTypeValue byRegex(String regex) {
        return this.byRegex(Pattern.compile(regex));
    }

    public RegexMatchingTypeValue byRegex(RegexProperty regex) {
        this.assertNotNull(regex);
        return new RegexMatchingTypeValue(MatchingType.REGEX, regex);
    }

    public RegexMatchingTypeValue byRegex(Pattern regex) {
        this.assertNotNull(regex);
        return new RegexMatchingTypeValue(MatchingType.REGEX, new RegexProperty(regex));
    }

    public MatchingTypeValue byEquality() {
        return new MatchingTypeValue(MatchingType.EQUALITY);
    }

    private void assertNotNull(Object object) {
        if (object == null) {
            throw new IllegalStateException("Object can't be null!");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BodyMatchers that = (BodyMatchers)o;
        return Objects.equals(this.matchers, that.matchers);
    }

    public int hashCode() {
        return Objects.hash(this.matchers);
    }

    public String toString() {
        return "BodyMatchers{\nmatchers=" + this.matchers + "}";
    }

    public MatchingTypeValue byType(Consumer<MatchingTypeValueHolder> consumer) {
        MatchingTypeValueHolder matchingTypeValue = new MatchingTypeValueHolder();
        consumer.accept(matchingTypeValue);
        return matchingTypeValue.matchingTypeValue;
    }

    public MatchingTypeValue byType(@DelegatesTo(value=MatchingTypeValueHolder.class) Closure consumer) {
        MatchingTypeValueHolder matchingTypeValue = new MatchingTypeValueHolder();
        consumer.setDelegate((Object)matchingTypeValue);
        consumer.call();
        return matchingTypeValue.matchingTypeValue;
    }
}

