/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.spec.internal.ClientDslProperty;
import org.springframework.cloud.contract.spec.internal.DslProperty;
import org.springframework.cloud.contract.spec.internal.ExecutionProperty;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.spec.internal.MatchingStrategy;
import org.springframework.cloud.contract.spec.internal.NamedProperty;
import org.springframework.cloud.contract.spec.internal.OptionalProperty;
import org.springframework.cloud.contract.spec.internal.RegexPatterns;
import org.springframework.cloud.contract.spec.internal.RegexProperty;
import org.springframework.cloud.contract.spec.internal.ServerDslProperty;

public class Common {
    public Map<String, DslProperty> convertObjectsToDslProperties(Map<String, Object> body) {
        return body.entrySet().stream().collect(Collectors.toMap(t -> t.getKey().toString(), t -> this.toDslProperty(t.getValue()), Common.throwingMerger(), LinkedHashMap::new));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public Collection convertObjectsToDslProperties(List<Object> body) {
        return body.stream().map(this::toDslProperty).collect(Collectors.toList());
    }

    public DslProperty toDslProperty(Object property) {
        return new DslProperty<Object>(property);
    }

    public DslProperty toDslProperty(Map property) {
        return new DslProperty<Map<String, DslProperty>>(this.convertObjectsToDslProperties(property));
    }

    public DslProperty toDslProperty(List property) {
        return new DslProperty<Collection>(this.convertObjectsToDslProperties(property));
    }

    public DslProperty toDslProperty(DslProperty property) {
        return property;
    }

    public NamedProperty named(DslProperty name, DslProperty value) {
        return new NamedProperty(name, value);
    }

    public NamedProperty named(DslProperty name, DslProperty value, DslProperty contentType) {
        return new NamedProperty(name, value, contentType);
    }

    public NamedProperty named(Map<String, DslProperty> namedMap) {
        return new NamedProperty(namedMap);
    }

    public DslProperty value(DslProperty value) {
        return value;
    }

    public DslProperty $(DslProperty value) {
        return value;
    }

    public DslProperty value(Object value) {
        return new DslProperty<Object>(value);
    }

    public DslProperty $(Object value) {
        return new DslProperty<Object>(value);
    }

    public DslProperty value(ClientDslProperty client, ServerDslProperty server) {
        this.assertThatSidesMatch(client.getClientValue(), server.getServerValue());
        return new DslProperty(client.getClientValue(), server.getServerValue());
    }

    public DslProperty $(ClientDslProperty client, ServerDslProperty server) {
        return this.value(client, server);
    }

    public DslProperty value(ServerDslProperty server, ClientDslProperty client) {
        this.assertThatSidesMatch(client.getClientValue(), server.getServerValue());
        return new DslProperty(client.getClientValue(), server.getServerValue());
    }

    public DslProperty $(ServerDslProperty server, ClientDslProperty client) {
        return this.value(server, client);
    }

    public RegexProperty regex(String regex) {
        return this.regexProperty(Pattern.compile(regex));
    }

    public RegexProperty regex(RegexProperty regex) {
        return regex;
    }

    public RegexProperty regex(Pattern regex) {
        return this.regexProperty(regex);
    }

    public OptionalProperty optional(Object object) {
        return new OptionalProperty(object);
    }

    public RegexProperty regexProperty(Object object) {
        return new RegexProperty(object);
    }

    public ExecutionProperty execute(String commandToExecute) {
        return new ExecutionProperty(commandToExecute);
    }

    public ClientDslProperty client(Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    public ClientDslProperty stub(Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    public ClientDslProperty consumer(Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    public ServerDslProperty server(Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    public ClientDslProperty c(Object clientValue) {
        return new ClientDslProperty(clientValue);
    }

    public ServerDslProperty p(Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    public ServerDslProperty test(Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    public FromFileProperty file(String relativePath) {
        return this.file(relativePath, Charset.defaultCharset());
    }

    public FromFileProperty fileAsBytes(String relativePath) {
        return new FromFileProperty(this.fileLocation(relativePath), byte[].class);
    }

    public FromFileProperty file(String relativePath, Charset charset) {
        return new FromFileProperty(this.fileLocation(relativePath), String.class, charset);
    }

    private File fileLocation(String relativePath) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(relativePath);
        if (resource == null) {
            throw new IllegalStateException("File [" + relativePath + "] is not present");
        }
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public ServerDslProperty producer(Object serverValue) {
        return new ServerDslProperty(serverValue);
    }

    private void throwAbsentError() {
        throw new IllegalStateException("Absent cannot only be used only on one side");
    }

    private void assertThat(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalStateException(msg);
        }
    }

    public void assertThatSidesMatch(Object firstSide, Object secondSide) {
        if (firstSide instanceof OptionalProperty) {
            if (secondSide == null) {
                return;
            }
            this.assertThat(secondSide.toString().matches(((OptionalProperty)firstSide).optionalPattern()), "Pattern [" + ((OptionalProperty)firstSide).optionalPattern() + "] is not matched by [" + secondSide.toString() + "]");
        } else if ((firstSide instanceof Pattern || firstSide instanceof RegexProperty) && secondSide instanceof String) {
            Pattern pattern = firstSide instanceof Pattern ? (Pattern)firstSide : ((RegexProperty)firstSide).getPattern();
            this.assertThat(((String)secondSide).toString().matches(pattern.pattern()), "Pattern [" + pattern.pattern() + "] is not matched by [" + secondSide.toString() + "]");
        } else if ((secondSide instanceof Pattern || secondSide instanceof RegexProperty) && firstSide instanceof String) {
            Pattern pattern = secondSide instanceof Pattern ? (Pattern)secondSide : ((RegexProperty)secondSide).getPattern();
            this.assertThat(((String)firstSide).matches(pattern.pattern()), "Pattern [" + pattern.pattern() + "] is not matched by [" + firstSide.toString() + "]");
        } else if (firstSide instanceof MatchingStrategy && secondSide instanceof MatchingStrategy) {
            if (((MatchingStrategy)firstSide).getType().equals((Object)MatchingStrategy.Type.ABSENT) && !((MatchingStrategy)secondSide).getType().equals((Object)MatchingStrategy.Type.ABSENT)) {
                this.throwAbsentError();
            }
        } else if (firstSide instanceof MatchingStrategy) {
            if (((MatchingStrategy)firstSide).getType().equals((Object)MatchingStrategy.Type.ABSENT)) {
                this.throwAbsentError();
            }
        } else if (secondSide instanceof MatchingStrategy && ((MatchingStrategy)secondSide).getType().equals((Object)MatchingStrategy.Type.ABSENT)) {
            this.throwAbsentError();
        }
    }

    public RegexProperty onlyAlphaUnicode() {
        return RegexPatterns.onlyAlphaUnicode();
    }

    public RegexProperty alphaNumeric() {
        return RegexPatterns.alphaNumeric();
    }

    public RegexProperty number() {
        return RegexPatterns.number();
    }

    public RegexProperty positiveInt() {
        return RegexPatterns.positiveInt();
    }

    public RegexProperty anyBoolean() {
        return RegexPatterns.anyBoolean();
    }

    public RegexProperty anInteger() {
        return RegexPatterns.anInteger();
    }

    public RegexProperty aDouble() {
        return RegexPatterns.aDouble();
    }

    public RegexProperty ipAddress() {
        return RegexPatterns.ipAddress();
    }

    public RegexProperty hostname() {
        return RegexPatterns.hostname();
    }

    public RegexProperty email() {
        return RegexPatterns.email();
    }

    public RegexProperty url() {
        return RegexPatterns.url();
    }

    public RegexProperty httpsUrl() {
        return RegexPatterns.httpsUrl();
    }

    public RegexProperty uuid() {
        return RegexPatterns.uuid();
    }

    public RegexProperty isoDate() {
        return RegexPatterns.isoDate();
    }

    public RegexProperty isoDateTime() {
        return RegexPatterns.isoDateTime();
    }

    public RegexProperty isoTime() {
        return RegexPatterns.isoTime();
    }

    public RegexProperty iso8601WithOffset() {
        return RegexPatterns.iso8601WithOffset();
    }

    public RegexProperty nonEmpty() {
        return RegexPatterns.nonEmpty();
    }

    public RegexProperty nonBlank() {
        return RegexPatterns.nonBlank();
    }
}

