/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.spec.internal;

import org.springframework.cloud.contract.spec.ContractTemplate;

class CustomHandlebarsContractTemplate
implements ContractTemplate {
    CustomHandlebarsContractTemplate() {
    }

    @Override
    public String openingTemplate() {
        return "{{{";
    }

    @Override
    public String closingTemplate() {
        return "}}}";
    }

    @Override
    public String url() {
        return this.wrapped("request.url");
    }

    @Override
    public String query(String key) {
        return this.query(key, 0);
    }

    @Override
    public String query(String key, int index) {
        return this.wrapped("request.query." + key + ".[" + index + "]");
    }

    @Override
    public String path() {
        return this.wrapped("request.path");
    }

    @Override
    public String path(int index) {
        return this.wrapped("request.path.[" + index + "]");
    }

    @Override
    public String header(String key) {
        return this.header(key, 0);
    }

    @Override
    public String header(String key, int index) {
        return this.wrapped("request.headers." + key + ".[" + index + "]");
    }

    @Override
    public String cookie(String key) {
        return this.wrapped("request.cookies." + key);
    }

    @Override
    public String body() {
        return this.wrapped("request.body");
    }

    @Override
    public String escapedBody() {
        return this.wrapped("escapejsonbody");
    }

    @Override
    public String escapedBody(String jsonPath) {
        return this.body(jsonPath);
    }

    @Override
    public String body(String jsonPath) {
        return this.wrapped("jsonpath this '" + jsonPath + "'");
    }

    private String wrapped(String text) {
        return this.openingTemplate() + text + this.closingTemplate();
    }
}

