/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.inject.internal;

import java.util.stream.Stream;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.inject.internal.ConstructionProxyFactory;
import shaded.com.google.inject.internal.ConstructorInjector;
import shaded.com.google.inject.internal.DefaultConstructionProxyFactory;
import shaded.com.google.inject.internal.Errors;
import shaded.com.google.inject.internal.ErrorsException;
import shaded.com.google.inject.internal.FailableCache;
import shaded.com.google.inject.internal.InjectorImpl;
import shaded.com.google.inject.internal.InternalFlags;
import shaded.com.google.inject.internal.MembersInjectorImpl;
import shaded.com.google.inject.internal.MethodAspect;
import shaded.com.google.inject.internal.ProxyFactory;
import shaded.com.google.inject.internal.SingleParameterInjector;
import shaded.com.google.inject.spi.InjectionPoint;

final class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<InjectionPoint, ConstructorInjector<?>> cache = new FailableCache<InjectionPoint, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(constructorInjector, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public ConstructorInjector<?> get(InjectionPoint constructorInjector, Errors errors) throws ErrorsException {
        return this.cache.get(constructorInjector, errors);
    }

    boolean remove(InjectionPoint ip) {
        return this.cache.remove(ip);
    }

    private <T> ConstructorInjector<T> createConstructor(InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<?> membersInjector = this.injector.membersInjectorStore.get(injectionPoint.getDeclaringType(), errors);
        ConstructionProxyFactory factory = null;
        if (InternalFlags.isBytecodeGenEnabled()) {
            ImmutableList<MethodAspect> injectorAspects = this.injector.getBindingData().getMethodAspects();
            ImmutableList<MethodAspect> methodAspects = membersInjector.getAddedAspects().isEmpty() ? injectorAspects : Stream.concat(injectorAspects.stream(), membersInjector.getAddedAspects().stream()).collect(ImmutableList.toImmutableList());
            factory = new ProxyFactory(injectionPoint, methodAspects);
        } else {
            factory = new DefaultConstructionProxyFactory(injectionPoint);
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

