/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package shaded.shaded.org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactRequest;

/**
 */
class ArtifactRequestBuilder implements DependencyVisitor {

    private final RequestTrace trace;

    private final List<ArtifactRequest> requests;

    ArtifactRequestBuilder(RequestTrace trace) {
        this.trace = trace;
        this.requests = new ArrayList<>();
    }

    public List<ArtifactRequest> getRequests() {
        return requests;
    }

    public boolean visitEnter(DependencyNode node) {
        if (node.getDependency() != null) {
            ArtifactRequest request = new ArtifactRequest(node);
            request.setTrace(trace);
            requests.add(request);
        }

        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        return true;
    }
}
