/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.artifact.repository.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import shaded.org.apache.maven.artifact.repository.metadata.Plugin;
import shaded.org.apache.maven.artifact.repository.metadata.Snapshot;
import shaded.org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import shaded.org.apache.maven.artifact.repository.metadata.Versioning;

public class Metadata
implements Serializable,
Cloneable {
    private String modelVersion;
    private String groupId;
    private String artifactId;
    private Versioning versioning;
    private String version;
    @Deprecated
    private List<Plugin> plugins;
    private String modelEncoding = "UTF-8";

    public void addPlugin(Plugin plugin) {
        this.getPlugins().add(plugin);
    }

    public Metadata clone() {
        try {
            Metadata copy = (Metadata)super.clone();
            if (this.versioning != null) {
                copy.versioning = this.versioning.clone();
            }
            if (this.plugins != null) {
                copy.plugins = new ArrayList<Plugin>();
                for (Plugin item : this.plugins) {
                    copy.plugins.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public List<Plugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Plugin>();
        }
        return this.plugins;
    }

    public String getVersion() {
        return this.version;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public void removePlugin(Plugin plugin) {
        this.getPlugins().remove(plugin);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersioning(Versioning versioning) {
        this.versioning = versioning;
    }

    private String getSnapshotVersionKey(SnapshotVersion sv) {
        return sv.getClassifier() + ":" + sv.getExtension();
    }

    public boolean merge(Metadata sourceMetadata) {
        boolean changed = false;
        for (Plugin plugin : sourceMetadata.getPlugins()) {
            boolean found = false;
            for (Plugin preExisting : this.getPlugins()) {
                if (!preExisting.getPrefix().equals(plugin.getPrefix())) continue;
                found = true;
                break;
            }
            if (found) continue;
            Plugin mappedPlugin = new Plugin();
            mappedPlugin.setArtifactId(plugin.getArtifactId());
            mappedPlugin.setPrefix(plugin.getPrefix());
            mappedPlugin.setName(plugin.getName());
            this.addPlugin(mappedPlugin);
            changed = true;
        }
        Versioning versioning = sourceMetadata.getVersioning();
        if (versioning != null) {
            Versioning v = this.getVersioning();
            if (v == null) {
                v = new Versioning();
                this.setVersioning(v);
                changed = true;
            }
            for (String version : versioning.getVersions()) {
                if (v.getVersions().contains(version)) continue;
                changed = true;
                v.getVersions().add(version);
            }
            if ("null".equals(versioning.getLastUpdated())) {
                versioning.setLastUpdated(null);
            }
            if ("null".equals(v.getLastUpdated())) {
                v.setLastUpdated(null);
            }
            if (versioning.getLastUpdated() == null || versioning.getLastUpdated().length() == 0) {
                versioning.setLastUpdated(v.getLastUpdated());
            }
            if (v.getLastUpdated() == null || v.getLastUpdated().length() == 0 || versioning.getLastUpdated().compareTo(v.getLastUpdated()) >= 0) {
                changed = true;
                v.setLastUpdated(versioning.getLastUpdated());
                if (versioning.getRelease() != null) {
                    changed = true;
                    v.setRelease(versioning.getRelease());
                }
                if (versioning.getLatest() != null) {
                    changed = true;
                    v.setLatest(versioning.getLatest());
                }
                Snapshot s2 = v.getSnapshot();
                Snapshot snapshot = versioning.getSnapshot();
                if (snapshot != null) {
                    boolean updateSnapshotVersions = false;
                    if (s2 == null) {
                        s2 = new Snapshot();
                        v.setSnapshot(s2);
                        changed = true;
                        updateSnapshotVersions = true;
                    }
                    if (s2.getTimestamp() == null ? snapshot.getTimestamp() != null : !s2.getTimestamp().equals(snapshot.getTimestamp())) {
                        s2.setTimestamp(snapshot.getTimestamp());
                        changed = true;
                        updateSnapshotVersions = true;
                    }
                    if (s2.getBuildNumber() != snapshot.getBuildNumber()) {
                        s2.setBuildNumber(snapshot.getBuildNumber());
                        changed = true;
                    }
                    if (s2.isLocalCopy() != snapshot.isLocalCopy()) {
                        s2.setLocalCopy(snapshot.isLocalCopy());
                        changed = true;
                    }
                    if (updateSnapshotVersions) {
                        LinkedHashMap<String, SnapshotVersion> versions = new LinkedHashMap<String, SnapshotVersion>();
                        if (!v.getSnapshotVersions().isEmpty()) {
                            String key;
                            for (SnapshotVersion sv : versioning.getSnapshotVersions()) {
                                key = this.getSnapshotVersionKey(sv);
                                versions.put(key, sv);
                            }
                            if (!versions.isEmpty()) {
                                for (SnapshotVersion sv : v.getSnapshotVersions()) {
                                    key = this.getSnapshotVersionKey(sv);
                                    if (versions.containsKey(key)) continue;
                                    versions.put(key, sv);
                                }
                            }
                            v.setSnapshotVersions(new ArrayList<SnapshotVersion>(versions.values()));
                        }
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }
}

